/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.net.MalformedURLException;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmRepUtil;
import org.keycloak.testsuite.util.UserBuilder;

public class BruteForceTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    private RegisterPage registerPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    private TimeBasedOTP totp = new TimeBasedOTP();
    private int lifespan;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = RealmRepUtil.findUser(testRealm, "test-user@localhost");
        CredentialRepresentation credRep = new CredentialRepresentation();
        credRep.setType("totp");
        credRep.setValue("totpSecret");
        user.getCredentials().add(credRep);
        user.setTotp(Boolean.TRUE);
        testRealm.setBruteForceProtected(Boolean.valueOf(true));
        testRealm.setFailureFactor(Integer.valueOf(2));
        RealmRepUtil.findClientByClientId(testRealm, "test-app").setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        testRealm.getUsers().add(UserBuilder.create().username("user2").email("user2@localhost").password("password").build());
    }

    @Before
    public void config() {
    }

    @Before
    public void before() throws MalformedURLException {
        this.totp = new TimeBasedOTP();
    }

    public String getAdminToken() throws Exception {
        String clientId = "admin-cli";
        return this.oauth.doGrantAccessTokenRequest("master", "admin", "admin", null, clientId, null).getAccessToken();
    }

    public OAuthClient.AccessTokenResponse getTestToken(String password, String totp) throws Exception {
        return this.oauth.doGrantAccessTokenRequest("test", "test-user@localhost", password, totp, this.oauth.getClientId(), "password");
    }

    protected void clearUserFailures() throws Exception {
        this.adminClient.realm("test").attackDetection().clearBruteForceForUser(this.findUser("test-user@localhost").getId());
    }

    protected void clearAllUserFailures() throws Exception {
        this.adminClient.realm("test").attackDetection().clearAllBruteForce();
    }

    @Test
    public void testGrantInvalidPassword() throws Exception {
        String totpSecret = this.totp.generateTOTP("totpSecret");
        OAuthClient.AccessTokenResponse response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("invalid", totpSecret);
        Assert.assertNull((Object)response.getAccessToken());
        Assert.assertEquals((Object)response.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("invalid", totpSecret);
        Assert.assertNull((Object)response.getAccessToken());
        Assert.assertEquals((Object)response.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        Assert.assertNull((Object)response.getAccessToken());
        Assert.assertNotNull((Object)response.getError());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"Account temporarily disabled", (Object)response.getErrorDescription());
        this.events.clear();
        this.clearUserFailures();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
    }

    @Test
    public void testGrantInvalidOtp() throws Exception {
        String totpSecret = this.totp.generateTOTP("totpSecret");
        OAuthClient.AccessTokenResponse response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
        OAuthClient.AccessTokenResponse response2 = this.getTestToken("password", "shite");
        Assert.assertNull((Object)response2.getAccessToken());
        Assert.assertEquals((Object)response2.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response2.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        response2 = this.getTestToken("password", "shite");
        Assert.assertNull((Object)response2.getAccessToken());
        Assert.assertEquals((Object)response2.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response2.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        Assert.assertNull((Object)response.getAccessToken());
        Assert.assertNotNull((Object)response.getError());
        Assert.assertEquals((Object)response.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response.getErrorDescription(), (Object)"Account temporarily disabled");
        this.events.clear();
        this.clearUserFailures();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
    }

    @Test
    public void testGrantMissingOtp() throws Exception {
        String totpSecret = this.totp.generateTOTP("totpSecret");
        OAuthClient.AccessTokenResponse response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
        OAuthClient.AccessTokenResponse response2 = this.getTestToken("password", null);
        Assert.assertNull((Object)response2.getAccessToken());
        Assert.assertEquals((Object)response2.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response2.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        response2 = this.getTestToken("password", null);
        Assert.assertNull((Object)response2.getAccessToken());
        Assert.assertEquals((Object)response2.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response2.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        Assert.assertNull((Object)response.getAccessToken());
        Assert.assertNotNull((Object)response.getError());
        Assert.assertEquals((Object)response.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response.getErrorDescription(), (Object)"Account temporarily disabled");
        this.events.clear();
        this.clearUserFailures();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
    }

    @Test
    public void testBrowserInvalidPassword() throws Exception {
        this.loginSuccess();
        this.loginInvalidPassword();
        this.loginInvalidPassword();
        this.expectTemporarilyDisabled();
        this.clearUserFailures();
        this.loginSuccess();
        this.loginInvalidPassword();
        this.loginInvalidPassword();
        this.expectTemporarilyDisabled();
        this.clearAllUserFailures();
        this.loginSuccess();
    }

    @Test
    public void testBrowserInvalidPasswordDifferentCase() throws Exception {
        this.loginSuccess("test-user@localhost");
        this.loginInvalidPassword("test-User@localhost");
        this.loginInvalidPassword("Test-user@localhost");
        this.expectTemporarilyDisabled();
        this.clearAllUserFailures();
    }

    @Test
    public void testEmail() throws Exception {
        String userId = ((UserRepresentation)this.adminClient.realm("test").users().search("user2", null, null, null, Integer.valueOf(0), Integer.valueOf(1)).get(0)).getId();
        this.loginSuccess("user2@localhost");
        this.loginInvalidPassword("user2@localhost");
        this.loginInvalidPassword("user2@localhost");
        this.expectTemporarilyDisabled("user2@localhost", userId);
        this.clearAllUserFailures();
    }

    @Test
    public void testBrowserMissingPassword() throws Exception {
        this.loginSuccess();
        this.loginMissingPassword();
        this.loginMissingPassword();
        this.expectTemporarilyDisabled();
        this.clearUserFailures();
        this.loginSuccess();
    }

    @Test
    public void testBrowserInvalidTotp() throws Exception {
        this.loginSuccess();
        this.loginWithTotpFailure();
        this.loginWithTotpFailure();
        this.expectTemporarilyDisabled();
        this.clearUserFailures();
        this.loginSuccess();
    }

    @Test
    public void testBrowserMissingTotp() throws Exception {
        this.loginSuccess();
        this.loginWithMissingTotp();
        this.loginWithMissingTotp();
        this.expectTemporarilyDisabled();
        this.clearUserFailures();
        this.loginSuccess();
    }

    @Test
    public void testNonExistingAccounts() throws Exception {
        this.loginInvalidPassword("non-existent-user");
        this.loginInvalidPassword("non-existent-user");
        this.loginInvalidPassword("non-existent-user");
        this.registerUser("non-existent-user");
    }

    public void expectTemporarilyDisabled() throws Exception {
        this.expectTemporarilyDisabled("test-user@localhost", null);
    }

    public void expectTemporarilyDisabled(String username, String userId) throws Exception {
        this.loginPage.open();
        this.loginPage.login(username, "password");
        this.loginPage.assertCurrent();
        String src = this.driver.getPageSource();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        AssertEvents.ExpectedEvent event = this.events.expectLogin().session((String)null).error("user_temporarily_disabled").detail("username", username).removeDetail("consent");
        if (userId != null) {
            event.user(userId);
        }
        event.assertEvent();
    }

    public void loginSuccess() throws Exception {
        this.loginSuccess("test-user@localhost");
    }

    public void loginSuccess(String username) throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.loginTotpPage.assertCurrent();
        String totpSecret = this.totp.generateTOTP("totpSecret");
        this.loginTotpPage.login(totpSecret);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
        this.appPage.logout();
        this.events.clear();
    }

    public void loginWithTotpFailure() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login("123456");
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginPage.getError());
        this.events.clear();
    }

    public void loginWithMissingTotp() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login(null);
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginPage.getError());
        this.events.clear();
    }

    public void loginInvalidPassword() throws Exception {
        this.loginInvalidPassword("test-user@localhost");
    }

    public void loginInvalidPassword(String username) throws Exception {
        this.loginPage.open();
        this.loginPage.login(username, "invalid");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.events.clear();
    }

    public void loginMissingPassword() {
        this.loginPage.open();
        this.loginPage.missingPassword("test-user@localhost");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.events.clear();
    }

    public void registerUser(String username) {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("user", "name", username + "@localhost", username, "password", "password");
        Assert.assertNull((Object)this.registerPage.getInstruction());
        this.events.clear();
    }
}

