/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.forms.AbstractFlowTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.rest.representation.AuthenticatorState;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ExecutionBuilder;
import org.keycloak.testsuite.util.FlowBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmRepUtil;
import org.keycloak.testsuite.util.UserBuilder;

public class CustomFlowTest
extends AbstractFlowTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    @Page
    protected RegisterPage registerPage;
    private static String userId;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = UserBuilder.create().username("login-test").email("login@test.com").enabled(true).build();
        testRealm.getUsers().add(user);
        ClientRepresentation dummyClient = ClientBuilder.create().clientId("dummy-client").name("dummy-client").authenticatorType("testsuite-client-passthrough").directAccessGrants().build();
        testRealm.getClients().add(dummyClient);
        ClientRepresentation testApp = RealmRepUtil.findClientByClientId(testRealm, "test-app");
        testApp.setClientAuthenticatorType("testsuite-client-passthrough");
        testApp.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
    }

    @Before
    public void configureFlows() {
        userId = this.findUser("login-test").getId();
        AuthenticationFlowRepresentation flow = FlowBuilder.create().alias("dummy").description("dummy pass through flow").providerId("basic-flow").topLevel(true).builtIn(false).build();
        this.testRealm().flows().createFlow(flow);
        RealmRepresentation realm = this.testRealm().toRepresentation();
        realm.setBrowserFlow(flow.getAlias());
        realm.setDirectGrantFlow(flow.getAlias());
        this.testRealm().update(realm);
        flow = this.findFlowByAlias(flow.getAlias());
        AuthenticationExecutionRepresentation execution = ExecutionBuilder.create().parentFlow(flow.getId()).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString()).authenticator("testsuite-dummy-passthrough").priority(10).authenticatorFlow(false).build();
        this.testRealm().flows().addExecution(execution);
        flow = FlowBuilder.create().alias("dummy registration").description("dummy pass through registration").providerId("basic-flow").topLevel(true).builtIn(false).build();
        this.testRealm().flows().createFlow(flow);
        this.setRegistrationFlow(flow);
        flow = this.findFlowByAlias(flow.getAlias());
        execution = ExecutionBuilder.create().parentFlow(flow.getId()).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString()).authenticator("testsuite-dummy-registration").priority(10).authenticatorFlow(false).build();
        this.testRealm().flows().addExecution(execution);
        AuthenticationFlowRepresentation clientFlow = FlowBuilder.create().alias("client-dummy").description("dummy pass through flow").providerId("client-flow").topLevel(true).builtIn(false).build();
        this.testRealm().flows().createFlow(clientFlow);
        realm = this.testRealm().toRepresentation();
        realm.setClientAuthenticationFlow(clientFlow.getAlias());
        this.testRealm().update(realm);
        clientFlow = this.findFlowByAlias(clientFlow.getAlias());
        execution = ExecutionBuilder.create().parentFlow(clientFlow.getId()).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString()).authenticator("testsuite-client-passthrough").priority(10).authenticatorFlow(false).build();
        this.testRealm().flows().addExecution(execution);
    }

    @Test
    public void loginSuccess() {
        AuthenticatorState state = new AuthenticatorState();
        state.setUsername("login-test");
        this.testingClient.testing().updateAuthenticator(state);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void grantTest() throws Exception {
        AuthenticatorState state = new AuthenticatorState();
        state.setUsername("login-test");
        this.testingClient.testing().updateAuthenticator(state);
        this.grantAccessToken("test-app", "login-test");
    }

    @Test
    public void clientAuthTest() throws Exception {
        AuthenticatorState state = new AuthenticatorState();
        state.setClientId("dummy-client");
        state.setUsername("login-test");
        this.testingClient.testing().updateAuthenticator(state);
        this.grantAccessToken("dummy-client", "login-test");
        state.setClientId("test-app");
        this.testingClient.testing().updateAuthenticator(state);
        this.grantAccessToken("test-app", "login-test");
        state.setClientId("unknown");
        this.testingClient.testing().updateAuthenticator(state);
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", "test-user", "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        this.events.expectLogin().client((String)null).user((String)null).session((String)null).removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").error("invalid_client_credentials").assertEvent();
    }

    private void grantAccessToken(String clientId, String login) throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", login, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(response.getRefreshToken());
        this.events.expectLogin().client(clientId).user(userId).session(accessToken.getSessionState()).detail("grant_type", "password").detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", login).detail("client_auth_method", "testsuite-client-passthrough").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshToken.getSessionState());
        OAuthClient.AccessTokenResponse refreshedResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        AccessToken refreshedAccessToken = this.oauth.verifyToken(refreshedResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.verifyRefreshToken(refreshedResponse.getRefreshToken());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedAccessToken.getSessionState());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedRefreshToken.getSessionState());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).user(userId).client(clientId).detail("client_auth_method", "testsuite-client-passthrough").assertEvent();
    }
}

