/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.forms.AbstractFlowTest;
import org.keycloak.testsuite.forms.PassThroughRegistration;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.util.ExecutionBuilder;
import org.keycloak.testsuite.util.FlowBuilder;

public class CustomRegistrationFlowTest
extends AbstractFlowTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    @Page
    protected RegisterPage registerPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void configureFlow() {
        AuthenticationFlowRepresentation flow = FlowBuilder.create().alias("dummy registration").description("dummy pass through registration").providerId("basic-flow").topLevel(true).builtIn(false).build();
        this.testRealm().flows().createFlow(flow);
        this.setRegistrationFlow(flow);
        flow = this.findFlowByAlias(flow.getAlias());
        AuthenticationExecutionRepresentation execution = ExecutionBuilder.create().parentFlow(flow.getId()).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString()).authenticator("testsuite-dummy-registration").priority(10).authenticatorFlow(false).build();
        this.testRealm().flows().addExecution(execution);
    }

    @Test
    public void registerUserSuccess() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        String userId = this.events.expectRegister(PassThroughRegistration.username, PassThroughRegistration.email).assertEvent().getUserId();
        this.events.expectLogin().detail("username", PassThroughRegistration.username).user(userId).assertEvent();
    }
}

