/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.net.MalformedURLException;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.RealmRepUtil;
import org.keycloak.testsuite.util.UserBuilder;

public class LoginHotpTest
extends TestRealmKeycloakTest {
    public static OTPPolicy policy;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    private HmacOTP otp;
    private int lifespan;
    private static int counter;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = RealmRepUtil.findUser(testRealm, "test-user@localhost");
        UserBuilder.edit(user).hotpSecret("hotpSecret").otpEnabled();
    }

    @Before
    public void before() throws MalformedURLException {
        RealmRepresentation testRealm = this.testRealm().toRepresentation();
        testRealm.setOtpPolicyType("hotp");
        testRealm.setOtpPolicyLookAheadWindow(Integer.valueOf(2));
        this.testRealm().update(testRealm);
        policy = new OTPPolicy();
        policy.setAlgorithm(testRealm.getOtpPolicyAlgorithm());
        policy.setDigits(testRealm.getOtpPolicyDigits().intValue());
        policy.setInitialCounter(testRealm.getOtpPolicyInitialCounter().intValue());
        policy.setLookAheadWindow(testRealm.getOtpPolicyLookAheadWindow().intValue());
        policy.setPeriod(testRealm.getOtpPolicyLookAheadWindow().intValue());
        policy.setType(testRealm.getOtpPolicyType());
        this.otp = new HmacOTP(policy.getDigits(), policy.getAlgorithm(), policy.getLookAheadWindow());
    }

    @Test
    public void loginWithHotpFailure() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.loginTotpPage.login("123456");
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginPage.getError());
        this.events.expectLogin().error("invalid_user_credentials").session((String)null).removeDetail("consent").assertEvent();
    }

    @Test
    public void loginWithMissingHotp() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.loginTotpPage.login(null);
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginPage.getError());
        this.events.expectLogin().error("invalid_user_credentials").session((String)null).removeDetail("consent").assertEvent();
    }

    @Test
    public void loginWithHotpSuccess() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.loginTotpPage.login(this.otp.generateHOTP("hotpSecret", counter++));
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void loginWithHotpInvalidPassword() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "invalid");
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.events.expectLogin().error("invalid_user_credentials").session((String)null).removeDetail("consent").assertEvent();
    }

    static {
        counter = 0;
    }
}

