/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.EventType;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class LoginTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    private static String userId;
    private static String user2Id;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = UserBuilder.create().id("login-test").username("login-test").email("login@test.com").enabled(true).password("password").build();
        userId = user.getId();
        UserRepresentation user2 = UserBuilder.create().id("login-test2").username("login-test2").email("login2@test.com").enabled(true).password("password").build();
        user2Id = user2.getId();
        RealmBuilder.edit(testRealm).user(user).user(user2);
    }

    @Test
    public void testBrowserSecurityHeaders() {
        Client client = ClientBuilder.newClient();
        Response response = client.target(this.oauth.getLoginFormUrl()).request().get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        for (Map.Entry entry : BrowserSecurityHeaders.defaultHeaders.entrySet()) {
            String headerName = (String)BrowserSecurityHeaders.headerAttributeMap.get(entry.getKey());
            String headerValue = response.getHeaderString(headerName);
            Assert.assertNotNull((Object)headerValue);
            Assert.assertEquals((Object)headerValue, entry.getValue());
        }
        response.close();
    }

    @Test
    public void loginChangeUserAfterInvalidPassword() {
        this.loginPage.open();
        this.loginPage.login("login-test2", "invalid");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"login-test2", (Object)this.loginPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.events.expectLogin().user(user2Id).session((String)null).error("invalid_user_credentials").detail("username", "login-test2").removeDetail("consent").assertEvent();
        this.loginPage.login("login-test", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void loginInvalidPassword() {
        this.loginPage.open();
        this.loginPage.login("login-test", "invalid");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.events.expectLogin().user(userId).session((String)null).error("invalid_user_credentials").detail("username", "login-test").removeDetail("consent").assertEvent();
    }

    @Test
    public void loginMissingPassword() {
        this.loginPage.open();
        this.loginPage.missingPassword("login-test");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.events.expectLogin().user(userId).session((String)null).error("invalid_user_credentials").detail("username", "login-test").removeDetail("consent").assertEvent();
    }

    private void setUserEnabled(String userName, boolean enabled) {
        UserRepresentation rep = this.adminClient.realm("test").users().get(userName).toRepresentation();
        rep.setEnabled(Boolean.valueOf(enabled));
        this.adminClient.realm("test").users().get(userName).update(rep);
    }

    @Test
    public void loginInvalidPasswordDisabledUser() {
        this.setUserEnabled("login-test", false);
        try {
            this.loginPage.open();
            this.loginPage.login("login-test", "invalid");
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
            Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
            Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
            this.events.expectLogin().user(userId).session((String)null).error("invalid_user_credentials").detail("username", "login-test").removeDetail("consent").assertEvent();
        }
        finally {
            this.setUserEnabled("login-test", true);
        }
    }

    @Test
    public void loginDisabledUser() {
        this.setUserEnabled("login-test", false);
        try {
            this.loginPage.open();
            this.loginPage.login("login-test", "password");
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
            Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
            Assert.assertEquals((Object)"Account is disabled, contact admin.", (Object)this.loginPage.getError());
            this.events.expectLogin().user(userId).session((String)null).error("user_disabled").detail("username", "login-test").removeDetail("consent").assertEvent();
        }
        finally {
            this.setUserEnabled("login-test", true);
        }
    }

    @Test
    public void loginInvalidUsername() {
        this.loginPage.open();
        this.loginPage.login("invalid", "password");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"invalid", (Object)this.loginPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.loginPage.getPassword());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.events.expectLogin().user((String)null).session((String)null).error("user_not_found").detail("username", "invalid").removeDetail("consent").assertEvent();
        this.loginPage.login("login-test", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void loginMissingUsername() {
        this.loginPage.open();
        this.loginPage.missingUsername();
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.events.expectLogin().user((String)null).session((String)null).error("user_not_found").removeDetail("consent").assertEvent();
    }

    @Test
    public void loginUserWithEmailAsUsername() {
        UserRepresentation rep = UserBuilder.create().enabled(true).id("foo").email("foo").username("login@test.com").password("password").build();
        this.adminClient.realm(userId).users().create(rep);
        this.loginPage.open();
        this.loginPage.login("login@test.com", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login@test.com").assertEvent();
    }

    @Test
    public void loginSuccess() {
        this.loginPage.open();
        this.loginPage.login("login-test", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void loginWithWhitespaceSuccess() {
        this.loginPage.open();
        this.loginPage.login(" login-test \t ", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void loginWithEmailWhitespaceSuccess() {
        this.loginPage.open();
        this.loginPage.login("    login@test.com    ", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).assertEvent();
    }

    private void setPasswordPolicy(String policy) {
        RealmRepresentation realmRep = this.adminClient.realm("test").toRepresentation();
        realmRep.setPasswordPolicy(policy);
        this.adminClient.realm("test").update(realmRep);
    }

    @Test
    public void loginWithForcePasswordChangePolicy() {
        this.setPasswordPolicy("forceExpiredPasswordChange(1)");
        try {
            this.setTimeOffset(86405);
            this.loginPage.open();
            this.loginPage.login("login-test", "password");
            this.updatePasswordPage.assertCurrent();
            this.updatePasswordPage.changePassword("updatedPassword", "updatedPassword");
            this.setTimeOffset(0);
            this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).user(userId).detail("username", "login-test").assertEvent();
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
        }
        finally {
            this.setPasswordPolicy(null);
            UserResource userRsc = this.adminClient.realm("test").users().get("login-test");
            UserBuilder userBuilder = UserBuilder.edit(userRsc.toRepresentation()).password("password");
            userRsc.update(userBuilder.build());
        }
    }

    @Test
    public void loginWithoutForcePasswordChangePolicy() {
        this.setPasswordPolicy("forceExpiredPasswordChange(1)");
        try {
            this.setTimeOffset(86205);
            this.loginPage.open();
            this.loginPage.login("login-test", "password");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
            this.setTimeOffset(0);
            this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
        }
        finally {
            this.setPasswordPolicy(null);
        }
    }

    @Test
    public void loginNoTimeoutWithLongWait() {
        this.loginPage.open();
        this.setTimeOffset(1700);
        this.loginPage.login("login-test", "password");
        this.setTimeOffset(0);
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent().getSessionId();
    }

    @Test
    public void loginTimeout() {
        this.loginPage.open();
        this.setTimeOffset(1850);
        this.loginPage.login("login-test", "password");
        this.setTimeOffset(0);
        this.events.expectLogin().clearDetails().detail("code_id", AssertEvents.isCodeId()).user((String)null).session((String)null).error("expired_code").assertEvent().getSessionId();
    }

    @Test
    public void loginLoginHint() {
        String loginFormUrl = this.oauth.getLoginFormUrl() + "&login_hint=login-test";
        this.driver.navigate().to(loginFormUrl);
        Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
        this.loginPage.login("password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void loginWithEmailSuccess() {
        this.loginPage.open();
        this.loginPage.login("login@test.com", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.events.expectLogin().user(userId).assertEvent();
    }

    private void setRememberMe(boolean enabled) {
        RealmRepresentation rep = this.adminClient.realm("test").toRepresentation();
        rep.setRememberMe(Boolean.valueOf(enabled));
        this.adminClient.realm("test").update(rep);
    }

    @Test
    public void loginWithRememberMe() {
        this.setRememberMe(true);
        try {
            this.loginPage.open();
            Assert.assertFalse((boolean)this.loginPage.isRememberMeChecked());
            this.loginPage.setRememberMe(true);
            Assert.assertTrue((boolean)this.loginPage.isRememberMeChecked());
            this.loginPage.login("login-test", "password");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
            EventRepresentation loginEvent = this.events.expectLogin().user(userId).detail("username", "login-test").detail("remember_me", "true").assertEvent();
            String sessionId = loginEvent.getSessionId();
            this.testingClient.testing().removeUserSession("test", sessionId);
            this.loginPage.open();
            Assert.assertTrue((boolean)this.loginPage.isRememberMeChecked());
            Assert.assertEquals((Object)"login-test", (Object)this.loginPage.getUsername());
            this.loginPage.setRememberMe(false);
        }
        finally {
            this.setRememberMe(false);
        }
    }

    @Test
    public void loginExpiredCode() {
        this.loginPage.open();
        this.setTimeOffset(5000);
        this.testingClient.testing().removeExpired("test");
        this.loginPage.login("login@test.com", "password");
        this.loginPage.assertCurrent();
        this.setTimeOffset(0);
        this.events.expectLogin().user((String)null).session((String)null).error("expired_code").clearDetails().detail("restart_after_timeout", "true").client((String)null).assertEvent();
    }
}

