/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.net.MalformedURLException;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.RealmRepUtil;
import org.keycloak.testsuite.util.UserBuilder;

public class LoginTotpTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    private TimeBasedOTP totp = new TimeBasedOTP();
    private int lifespan;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = RealmRepUtil.findUser(testRealm, "test-user@localhost");
        UserBuilder.edit(user).totpSecret("totpSecret").otpEnabled();
    }

    @Before
    public void before() throws MalformedURLException {
        this.totp = new TimeBasedOTP();
    }

    @Test
    public void loginWithTotpFailure() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.loginTotpPage.login("123456");
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginPage.getError());
        this.events.expectLogin().error("invalid_user_credentials").session((String)null).removeDetail("consent").assertEvent();
    }

    @Test
    public void loginWithMissingTotp() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.loginTotpPage.login(null);
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginPage.getError());
        this.events.expectLogin().error("invalid_user_credentials").session((String)null).removeDetail("consent").assertEvent();
    }

    @Test
    public void loginWithTotpSuccess() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.loginTotpPage.login(this.totp.generateTOTP("totpSecret"));
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void loginWithTotpCancel() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.loginTotpPage.cancel();
        this.loginPage.assertCurrent();
    }

    @Test
    public void loginWithTotpInvalidPassword() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "invalid");
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.events.expectLogin().error("invalid_user_credentials").session((String)null).removeDetail("consent").assertEvent();
    }
}

