/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.IOException;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;

public class LogoutTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void logoutRedirect() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId = this.events.expectLogin().assertEvent().getSessionId();
        String redirectUri = "http://localhost:8180/auth/realms/master/app/auth?logout";
        String logoutUrl = this.oauth.getLogoutUrl(redirectUri, null);
        this.driver.navigate().to(logoutUrl);
        this.events.expectLogout(sessionId).detail("redirect_uri", redirectUri).assertEvent();
        Assert.assertEquals((Object)redirectUri, (Object)this.driver.getCurrentUrl());
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId2 = this.events.expectLogin().assertEvent().getSessionId();
        Assert.assertNotEquals((Object)sessionId, (Object)sessionId2);
    }

    @Test
    public void logoutSession() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId = this.events.expectLogin().assertEvent().getSessionId();
        String logoutUrl = this.oauth.getLogoutUrl(null, sessionId);
        this.driver.navigate().to(logoutUrl);
        this.events.expectLogout(sessionId).removeDetail("redirect_uri").assertEvent();
        Assert.assertEquals((Object)logoutUrl, (Object)this.driver.getCurrentUrl());
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId2 = this.events.expectLogin().assertEvent().getSessionId();
        Assert.assertNotEquals((Object)sessionId, (Object)sessionId2);
    }

    @Test
    public void logoutMultipleSessions() throws IOException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        String sessionId = this.events.expectLogin().assertEvent().getSessionId();
        this.oauth.openLoginForm();
        this.events.expectLogin().session(sessionId).removeDetail("username").assertEvent();
        this.driver.navigate().to(this.oauth.getLogoutUrl("http://localhost:8180/auth/realms/master/app/auth", null));
        this.events.expectLogout(sessionId).detail("redirect_uri", "http://localhost:8180/auth/realms/master/app/auth").assertEvent();
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)this.oauth.getLoginFormUrl(), (Object)this.driver.getCurrentUrl());
        this.oauth.doLogin("test-user@localhost", "password");
        String sessionId3 = this.events.expectLogin().assertEvent().getSessionId();
        Assert.assertNotEquals((Object)sessionId, (Object)sessionId3);
        this.oauth.openLoginForm();
        this.events.expectLogin().session(sessionId3).removeDetail("username").assertEvent();
    }
}

