/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import org.jboss.arquillian.graphene.page.Page;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class RegisterTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected RegisterPage registerPage;
    @Page
    protected AccountUpdateProfilePage accountPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void registerExistingUser() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerExistingUser@email", "test-user@localhost", "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Username already exists.", (Object)this.registerPage.getError());
        Assert.assertEquals((Object)"firstName", (Object)this.registerPage.getFirstName());
        Assert.assertEquals((Object)"lastName", (Object)this.registerPage.getLastName());
        Assert.assertEquals((Object)"registerExistingUser@email", (Object)this.registerPage.getEmail());
        Assert.assertEquals((Object)"", (Object)this.registerPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.registerPage.getPassword());
        Assert.assertEquals((Object)"", (Object)this.registerPage.getPasswordConfirm());
        this.events.expectRegister("test-user@localhost", "registerExistingUser@email").removeDetail("email").user((String)null).error("username_in_use").assertEvent();
    }

    @Test
    public void registerUserInvalidPasswordConfirm() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerUserInvalidPasswordConfirm@email", "registerUserInvalidPasswordConfirm", "password", "invalid");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Password confirmation doesn't match.", (Object)this.registerPage.getError());
        Assert.assertEquals((Object)"firstName", (Object)this.registerPage.getFirstName());
        Assert.assertEquals((Object)"lastName", (Object)this.registerPage.getLastName());
        Assert.assertEquals((Object)"registerUserInvalidPasswordConfirm@email", (Object)this.registerPage.getEmail());
        Assert.assertEquals((Object)"registerUserInvalidPasswordConfirm", (Object)this.registerPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.registerPage.getPassword());
        Assert.assertEquals((Object)"", (Object)this.registerPage.getPasswordConfirm());
        this.events.expectRegister("registerUserInvalidPasswordConfirm", "registerUserInvalidPasswordConfirm@email").removeDetail("username").removeDetail("email").user((String)null).error("invalid_registration").assertEvent();
    }

    @Test
    public void registerUserMissingPassword() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerUserMissingPassword@email", "registerUserMissingPassword", null, null);
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify password.", (Object)this.registerPage.getError());
        this.events.expectRegister("registerUserMissingPassword", "registerUserMissingPassword@email").removeDetail("username").removeDetail("email").user((String)null).error("invalid_registration").assertEvent();
    }

    @Test
    public void registerPasswordPolicy() {
        RealmRepresentation realm = this.testRealm().toRepresentation();
        realm.setPasswordPolicy("length");
        this.testRealm().update(realm);
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerPasswordPolicy@email", "registerPasswordPolicy", "pass", "pass");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid password: minimum length 8.", (Object)this.registerPage.getError());
        this.events.expectRegister("registerPasswordPolicy", "registerPasswordPolicy@email").removeDetail("username").removeDetail("email").user((String)null).error("invalid_registration").assertEvent();
        this.registerPage.register("firstName", "lastName", "registerPasswordPolicy@email", "registerPasswordPolicy", "password", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        String userId = this.events.expectRegister("registerPasswordPolicy", "registerPasswordPolicy@email").assertEvent().getUserId();
        this.events.expectLogin().user(userId).detail("username", "registerpasswordpolicy").assertEvent();
    }

    @Test
    public void registerUserMissingUsername() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerUserMissingUsername@email", null, "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify username.", (Object)this.registerPage.getError());
        this.events.expectRegister(null, "registerUserMissingUsername@email").removeDetail("username").removeDetail("email").error("invalid_registration").assertEvent();
    }

    @Test
    public void registerUserManyErrors() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register(null, null, null, null, null, null);
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify username.\nPlease specify first name.\nPlease specify last name.\nPlease specify email.\nPlease specify password.", (Object)this.registerPage.getError());
        this.events.expectRegister(null, "registerUserMissingUsername@email").removeDetail("username").removeDetail("email").error("invalid_registration").assertEvent();
    }

    @Test
    public void registerUserMissingEmail() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", null, "registerUserMissingEmail", "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify email.", (Object)this.registerPage.getError());
        this.events.expectRegister("registerUserMissingEmail", null).removeDetail("email").error("invalid_registration").assertEvent();
    }

    @Test
    public void registerUserInvalidEmail() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerUserInvalidEmailemail", "registerUserInvalidEmail", "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"registerUserInvalidEmailemail", (Object)this.registerPage.getEmail());
        Assert.assertEquals((Object)"Invalid email address.", (Object)this.registerPage.getError());
        this.events.expectRegister("registerUserInvalidEmail", "registerUserInvalidEmailemail").error("invalid_registration").assertEvent();
    }

    @Test
    public void registerUserSuccess() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerUserSuccess@email", "registerUserSuccess", "password", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        String userId = this.events.expectRegister("registerUserSuccess", "registerUserSuccess@email").assertEvent().getUserId();
        this.events.expectLogin().detail("username", "registerusersuccess").user(userId).assertEvent();
        UserRepresentation user = this.getUser(userId);
        Assert.assertNotNull((Object)user);
        Assert.assertNotNull((Object)user.getCreatedTimestamp());
        Assert.assertTrue((System.currentTimeMillis() - user.getCreatedTimestamp() < 10000L ? 1 : 0) != 0);
        Assert.assertEquals((Object)"registerusersuccess", (Object)user.getUsername());
        Assert.assertEquals((Object)"registerusersuccess@email", (Object)user.getEmail());
        Assert.assertEquals((Object)"firstName", (Object)user.getFirstName());
        Assert.assertEquals((Object)"lastName", (Object)user.getLastName());
    }

    @Test
    public void registerUserUmlats() {
        this.loginPage.open();
        Util.assertTrue((boolean)this.loginPage.isCurrent());
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("\u00c4\u01dc\u1e73\u01da\u01d8\u01d6", "\u00d6\u1e4f\u1e4f", "registeruserumlats@email", "registeruserumlats", "password", "password");
        String userId = this.events.expectRegister("registeruserumlats", "registeruserumlats@email").assertEvent().getUserId();
        this.events.expectLogin().detail("username", "registeruserumlats").user(userId).assertEvent();
        this.accountPage.open();
        Util.assertTrue((boolean)this.accountPage.isCurrent());
        UserRepresentation user = this.getUser(userId);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"\u00c4\u01dc\u1e73\u01da\u01d8\u01d6", (Object)user.getFirstName());
        Assert.assertEquals((Object)"\u00d6\u1e4f\u1e4f", (Object)user.getLastName());
        Assert.assertEquals((Object)"\u00c4\u01dc\u1e73\u01da\u01d8\u01d6", (Object)this.accountPage.getFirstName());
        Assert.assertEquals((Object)"\u00d6\u1e4f\u1e4f", (Object)this.accountPage.getLastName());
    }

    @Test
    public void registerUserNotUsernamePasswordPolicy() {
        this.adminClient.realm("test").update(RealmBuilder.create().passwordPolicy("notUsername").build());
        this.loginPage.open();
        Util.assertTrue((boolean)this.loginPage.isCurrent());
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerUserNotUsername@email", "registerUserNotUsername", "registerUserNotUsername", "registerUserNotUsername");
        Util.assertTrue((boolean)this.registerPage.isCurrent());
        Assert.assertEquals((Object)"Invalid password: must not be equal to the username.", (Object)this.registerPage.getError());
        this.adminClient.realm("test").users().create(UserBuilder.create().username("registerUserNotUsername").build());
        this.registerPage.register("firstName", "lastName", "registerUserNotUsername@email", "registerUserNotUsername", "registerUserNotUsername", "registerUserNotUsername");
        Util.assertTrue((boolean)this.registerPage.isCurrent());
        Assert.assertEquals((Object)"Username already exists.", (Object)this.registerPage.getError());
        this.registerPage.register("firstName", "lastName", "registerUserNotUsername@email", null, "password", "password");
        Util.assertTrue((boolean)this.registerPage.isCurrent());
        Assert.assertEquals((Object)"Please specify username.", (Object)this.registerPage.getError());
    }

    protected UserRepresentation getUser(String userId) {
        return this.testRealm().users().get(userId).toRepresentation();
    }

    @Test
    public void registerExistingUser_emailAsUsername() {
        this.configureRelamRegistrationEmailAsUsername(true);
        try {
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.registerWithEmailAsUsername("firstName", "lastName", "test-user@localhost", "password", "password");
            this.registerPage.assertCurrent();
            Assert.assertEquals((Object)"Email already exists.", (Object)this.registerPage.getError());
            this.events.expectRegister("test-user@localhost", "test-user@localhost").user((String)null).error("email_in_use").assertEvent();
        }
        finally {
            this.configureRelamRegistrationEmailAsUsername(false);
        }
    }

    @Test
    public void registerUserMissingOrInvalidEmail_emailAsUsername() {
        this.configureRelamRegistrationEmailAsUsername(true);
        try {
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.registerWithEmailAsUsername("firstName", "lastName", null, "password", "password");
            this.registerPage.assertCurrent();
            Assert.assertEquals((Object)"Please specify email.", (Object)this.registerPage.getError());
            this.events.expectRegister(null, null).removeDetail("username").removeDetail("email").error("invalid_registration").assertEvent();
            this.registerPage.registerWithEmailAsUsername("firstName", "lastName", "registerUserInvalidEmailemail", "password", "password");
            this.registerPage.assertCurrent();
            Assert.assertEquals((Object)"Invalid email address.", (Object)this.registerPage.getError());
            this.events.expectRegister("registerUserInvalidEmailemail", "registerUserInvalidEmailemail").error("invalid_registration").assertEvent();
        }
        finally {
            this.configureRelamRegistrationEmailAsUsername(false);
        }
    }

    @Test
    public void registerUserSuccess_emailAsUsername() {
        this.configureRelamRegistrationEmailAsUsername(true);
        try {
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.registerWithEmailAsUsername("firstName", "lastName", "registerUserSuccessE@email", "password", "password");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            String userId = this.events.expectRegister("registerUserSuccessE@email", "registerUserSuccessE@email").assertEvent().getUserId();
            this.events.expectLogin().detail("username", "registerusersuccesse@email").user(userId).assertEvent();
            UserRepresentation user = this.getUser(userId);
            Assert.assertNotNull((Object)user);
            Assert.assertNotNull((Object)user.getCreatedTimestamp());
            Assert.assertTrue((System.currentTimeMillis() - user.getCreatedTimestamp() < 10000L ? 1 : 0) != 0);
        }
        finally {
            this.configureRelamRegistrationEmailAsUsername(false);
        }
    }

    protected void configureRelamRegistrationEmailAsUsername(boolean value) {
        RealmRepresentation realm = this.testRealm().toRepresentation();
        realm.setRegistrationEmailAsUsername(Boolean.valueOf(value));
        this.testRealm().update(realm);
    }
}

