/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.InfoPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordResetPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.VerifyEmailPage;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.MailUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UserBuilder;

public class ResetPasswordTest
extends TestRealmKeycloakTest {
    static int lifespan = 0;
    private static String userId;
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected InfoPage infoPage;
    @Page
    protected VerifyEmailPage verifyEmailPage;
    @Page
    protected LoginPasswordResetPage resetPasswordPage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = UserBuilder.create().username("login-test").email("login@test.com").enabled(true).password("password").build();
        testRealm.getUsers().add(user);
    }

    @Before
    public void setAccessCodeLifespanUserAction() {
        lifespan = this.testRealm().toRepresentation().getAccessCodeLifespanUserAction();
    }

    @Before
    public void setUserId() {
        userId = this.findUser("login-test").getId();
    }

    @Test
    public void resetPasswordLink() throws IOException, MessagingException {
        String username = "login-test";
        String resetUri = OAuthClient.AUTH_SERVER_ROOT + "/realms/test/login-actions/reset-credentials";
        this.driver.navigate().to(resetUri);
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword(username);
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).user(userId).detail("redirect_uri", OAuthClient.AUTH_SERVER_ROOT + "/realms/test/account/").client("account").detail("username", username).detail("email", "login@test.com").session((String)null).assertEvent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String changePasswordUrl = ResetPasswordTest.getPasswordResetEmailLink(message);
        this.driver.navigate().to(changePasswordUrl.trim());
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("resetPassword", "resetPassword");
        String sessionId = this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).detail("redirect_uri", OAuthClient.AUTH_SERVER_ROOT + "/realms/test/account/").client("account").user(userId).detail("username", username).assertEvent().getSessionId();
        this.events.expectLogin().user(userId).detail("username", username).detail("redirect_uri", OAuthClient.AUTH_SERVER_ROOT + "/realms/test/account/").client("account").session(sessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(sessionId).user(userId).session(sessionId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("login-test", "resetPassword");
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
    }

    @Test
    public void resetPassword() throws IOException, MessagingException {
        this.resetPassword("login-test");
    }

    @Test
    public void resetPasswordCancelChangeUser() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword("test-user@localhost");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).detail("username", "test-user@localhost").session((String)null).detail("email", "test-user@localhost").assertEvent();
        this.loginPage.login("login@test.com", "password");
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).detail("username", "login@test.com").assertEvent();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        Assert.assertEquals((Object)userId, (Object)this.oauth.verifyToken(tokenResponse.getAccessToken()).getSubject());
        this.events.expectCodeToToken((String)loginEvent.getDetails().get("code_id"), loginEvent.getSessionId()).user(userId).assertEvent();
    }

    @Test
    public void resetPasswordByEmail() throws IOException, MessagingException {
        this.resetPassword("login@test.com");
    }

    private void resetPassword(String username) throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword(username);
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).user(userId).detail("username", username).detail("email", "login@test.com").session((String)null).assertEvent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String changePasswordUrl = ResetPasswordTest.getPasswordResetEmailLink(message);
        this.driver.navigate().to(changePasswordUrl.trim());
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("resetPassword", "resetPassword");
        String sessionId = this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).user(userId).detail("username", username).assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().user(userId).detail("username", username).session(sessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(sessionId).user(userId).session(sessionId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("login-test", "resetPassword");
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
    }

    private void resetPassword(String username, String password) throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword(username);
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).user(userId).session((String)null).detail("username", username).detail("email", "login@test.com").assertEvent();
        MimeMessage message = this.greenMail.getReceivedMessages()[this.greenMail.getReceivedMessages().length - 1];
        String changePasswordUrl = ResetPasswordTest.getPasswordResetEmailLink(message);
        this.driver.navigate().to(changePasswordUrl.trim());
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword(password, password);
        String sessionId = this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).user(userId).detail("username", username).assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().user(userId).detail("username", username).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(sessionId).user(userId).session(sessionId).assertEvent();
    }

    private void resetPasswordInvalidPassword(String username, String password, String error) throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword(username);
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).user(userId).session((String)null).detail("username", username).detail("email", "login@test.com").assertEvent();
        MimeMessage message = this.greenMail.getReceivedMessages()[this.greenMail.getReceivedMessages().length - 1];
        String changePasswordUrl = ResetPasswordTest.getPasswordResetEmailLink(message);
        this.driver.navigate().to(changePasswordUrl.trim());
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword(password, password);
        Assert.assertTrue((boolean)this.updatePasswordPage.isCurrent());
        Assert.assertEquals((Object)error, (Object)this.updatePasswordPage.getError());
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").user(userId).detail("username", "login-test").assertEvent().getSessionId();
    }

    @Test
    public void resetPasswordWrongEmail() throws IOException, MessagingException, InterruptedException {
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword("invalid");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
        this.events.expectRequiredAction(EventType.RESET_PASSWORD).user((String)null).session((String)null).detail("username", "invalid").removeDetail("email").removeDetail("code_id").error("user_not_found").assertEvent();
    }

    @Test
    public void resetPasswordMissingUsername() throws IOException, MessagingException, InterruptedException {
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword("");
        this.resetPasswordPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify username.", (Object)this.resetPasswordPage.getErrorMessage());
        Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
        this.events.expectRequiredAction(EventType.RESET_PASSWORD).user((String)null).session((String)null).clearDetails().error("username_missing").assertEvent();
    }

    @Test
    public void resetPasswordExpiredCode() throws IOException, MessagingException, InterruptedException {
        try {
            this.loginPage.open();
            this.loginPage.resetPassword();
            this.resetPasswordPage.assertCurrent();
            this.resetPasswordPage.changePassword("login-test");
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = ResetPasswordTest.getPasswordResetEmailLink(message);
            this.setTimeOffset(1823);
            this.driver.navigate().to(changePasswordUrl.trim());
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"You took too long to login. Login process starting from beginning.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.RESET_PASSWORD).error("expired_code").client("test-app").user((String)null).session((String)null).clearDetails().assertEvent();
        }
        finally {
            this.setTimeOffset(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordExpiredCodeShort() throws IOException, MessagingException, InterruptedException {
        AtomicInteger originalValue = new AtomicInteger();
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        originalValue.set(realmRep.getAccessCodeLifespan());
        realmRep.setAccessCodeLifespanUserAction(Integer.valueOf(60));
        this.testRealm().update(realmRep);
        try {
            this.loginPage.open();
            this.loginPage.resetPassword();
            this.resetPasswordPage.assertCurrent();
            this.resetPasswordPage.changePassword("login-test");
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = ResetPasswordTest.getPasswordResetEmailLink(message);
            this.setTimeOffset(70);
            this.driver.navigate().to(changePasswordUrl.trim());
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"You took too long to login. Login process starting from beginning.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.RESET_PASSWORD).error("expired_code").client("test-app").user((String)null).session((String)null).clearDetails().assertEvent();
        }
        finally {
            this.setTimeOffset(0);
        }
    }

    @Test
    public void resetPasswordDisabledUser() throws IOException, MessagingException, InterruptedException {
        UserRepresentation user = this.findUser("login-test");
        user.setEnabled(Boolean.valueOf(false));
        this.updateUser(user);
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword("login-test");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
        this.events.expectRequiredAction(EventType.RESET_PASSWORD).session((String)null).user(userId).detail("username", "login-test").removeDetail("code_id").error("user_disabled").assertEvent();
    }

    @Test
    public void resetPasswordNoEmail() throws IOException, MessagingException, InterruptedException {
        String[] email = new String[1];
        UserRepresentation user = this.findUser("login-test");
        email[0] = user.getEmail();
        user.setEmail("");
        this.updateUser(user);
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword("login-test");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
        this.events.expectRequiredAction(EventType.RESET_PASSWORD_ERROR).session((String)null).user(userId).detail("username", "login-test").removeDetail("code_id").error("invalid_email").assertEvent();
    }

    @Test
    public void resetPasswordWrongSmtp() throws IOException, MessagingException, InterruptedException {
        String[] host = new String[1];
        HashMap<String, String> smtpConfig = new HashMap<String, String>();
        smtpConfig.putAll(this.testRealm().toRepresentation().getSmtpServer());
        host[0] = (String)smtpConfig.get("host");
        smtpConfig.put("host", "invalid_host");
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        realmRep.setSmtpServer(smtpConfig);
        this.testRealm().update(realmRep);
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword("login-test");
        this.errorPage.assertCurrent();
        Assert.assertEquals((Object)"Failed to send email, please try again later.", (Object)this.errorPage.getError());
        Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD_ERROR).user(userId).session((String)null).detail("username", "login-test").removeDetail("code_id").error("email_send_failed").assertEvent();
    }

    private void setPasswordPolicy(String policy) {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        realmRep.setPasswordPolicy(policy);
        this.testRealm().update(realmRep);
    }

    @Test
    public void resetPasswordWithLengthPasswordPolicy() throws IOException, MessagingException {
        this.setPasswordPolicy("length");
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword("login-test");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String changePasswordUrl = ResetPasswordTest.getPasswordResetEmailLink(message);
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
        this.driver.navigate().to(changePasswordUrl.trim());
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("invalid", "invalid");
        Assert.assertEquals((Object)"Invalid password: minimum length 8.", (Object)this.resetPasswordPage.getErrorMessage());
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").user(userId).detail("username", "login-test").assertEvent().getSessionId();
        this.updatePasswordPage.changePassword("resetPasswordWithPasswordPolicy", "resetPasswordWithPasswordPolicy");
        String sessionId = this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).user(userId).detail("username", "login-test").assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().user(userId).detail("username", "login-test").session(sessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(sessionId).user(userId).session(sessionId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("login-test", "resetPasswordWithPasswordPolicy");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().user(userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void resetPasswordWithPasswordHisoryPolicy() throws IOException, MessagingException {
        this.setPasswordPolicy("passwordHistory");
        try {
            this.setTimeOffset(2000000);
            this.resetPassword("login-test", "password1");
            this.resetPasswordInvalidPassword("login-test", "password1", "Invalid password: must not be equal to any of last 3 passwords.");
            this.setTimeOffset(4000000);
            this.resetPassword("login-test", "password2");
            this.resetPasswordInvalidPassword("login-test", "password1", "Invalid password: must not be equal to any of last 3 passwords.");
            this.resetPasswordInvalidPassword("login-test", "password2", "Invalid password: must not be equal to any of last 3 passwords.");
            this.setTimeOffset(8000000);
            this.resetPassword("login-test", "password3");
            this.resetPasswordInvalidPassword("login-test", "password1", "Invalid password: must not be equal to any of last 3 passwords.");
            this.resetPasswordInvalidPassword("login-test", "password2", "Invalid password: must not be equal to any of last 3 passwords.");
            this.resetPasswordInvalidPassword("login-test", "password3", "Invalid password: must not be equal to any of last 3 passwords.");
            this.resetPassword("login-test", "password");
        }
        finally {
            this.setTimeOffset(0);
        }
    }

    public static String getPasswordResetEmailLink(MimeMessage message) throws IOException, MessagingException {
        Multipart multipart = (Multipart)message.getContent();
        String textContentType = multipart.getBodyPart(0).getContentType();
        Assert.assertEquals((Object)"text/plain; charset=UTF-8", (Object)textContentType);
        String textBody = (String)multipart.getBodyPart(0).getContent();
        String textChangePwdUrl = MailUtils.getLink((String)textBody);
        String htmlContentType = multipart.getBodyPart(1).getContentType();
        Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)htmlContentType);
        String htmlBody = (String)multipart.getBodyPart(1).getContent();
        String htmlChangePwdUrl = MailUtils.getLink((String)htmlBody);
        Assert.assertEquals((Object)htmlChangePwdUrl, (Object)textChangePwdUrl);
        return htmlChangePwdUrl;
    }
}

