/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.i18n;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.i18n.AbstractI18NTest;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordResetPage;
import org.keycloak.testsuite.util.GreenMailRule;

public class EmailTest
extends AbstractI18NTest {
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginPasswordResetPage resetPasswordPage;

    private void changeUserLocale(String locale) {
        UserRepresentation user = this.findUser("login-test");
        if (user.getAttributes() == null) {
            user.setAttributes(new HashMap());
        }
        user.getAttributes().put("locale", Collections.singletonList(locale));
        ApiUtil.findUserByUsernameId(this.testRealm(), "login-test").update(user);
    }

    @Test
    public void restPasswordEmail() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.changePassword("login-test");
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        Assert.assertEquals((Object)"Reset password", (Object)message.getSubject());
        this.changeUserLocale("en");
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.changePassword("login-test");
        Assert.assertEquals((long)2L, (long)this.greenMail.getReceivedMessages().length);
        message = this.greenMail.getReceivedMessages()[1];
        Assert.assertEquals((Object)"Reset password", (Object)message.getSubject());
    }

    @Test
    public void restPasswordEmailGerman() throws IOException, MessagingException {
        this.changeUserLocale("de");
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.changePassword("login-test");
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        Assert.assertEquals((Object)"Passwort zur\u00fcckzusetzen", (Object)message.getSubject());
    }
}

