/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.i18n;

import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.testsuite.i18n.AbstractI18NTest;
import org.keycloak.testsuite.pages.LoginPage;

public class LoginPageTest
extends AbstractI18NTest {
    @Page
    protected LoginPage loginPage;

    @Test
    public void languageDropdown() {
        this.loginPage.open();
        Assert.assertEquals((Object)"English", (Object)this.loginPage.getLanguageDropdownText());
        this.loginPage.openLanguage("Deutsch");
        Assert.assertEquals((Object)"Deutsch", (Object)this.loginPage.getLanguageDropdownText());
        this.loginPage.openLanguage("English");
        Assert.assertEquals((Object)"English", (Object)this.loginPage.getLanguageDropdownText());
    }

    @Test
    public void uiLocalesParameter() {
        this.loginPage.open();
        Assert.assertEquals((Object)"English", (Object)this.loginPage.getLanguageDropdownText());
        this.oauth.uiLocales("de");
        this.loginPage.open();
        Assert.assertEquals((Object)"Deutsch", (Object)this.loginPage.getLanguageDropdownText());
        this.driver.manage().deleteAllCookies();
        this.loginPage.open();
        Assert.assertEquals((Object)"Deutsch", (Object)this.loginPage.getLanguageDropdownText());
        this.oauth.uiLocales("en de");
        this.driver.manage().deleteAllCookies();
        this.loginPage.open();
        Assert.assertEquals((Object)"English", (Object)this.loginPage.getLanguageDropdownText());
        this.oauth.uiLocales("fr de");
        this.driver.manage().deleteAllCookies();
        this.loginPage.open();
        Assert.assertEquals((Object)"Deutsch", (Object)this.loginPage.getLanguageDropdownText());
    }

    @Test
    public void acceptLanguageHeader() {
        DefaultHttpClient httpClient = (DefaultHttpClient)new HttpClientBuilder().build();
        ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
        this.loginPage.open();
        Response response = client.target(this.driver.getCurrentUrl()).request().acceptLanguage(new String[]{"de"}).get();
        Assert.assertTrue((boolean)((String)response.readEntity(String.class)).contains("Anmeldung bei test"));
        response = client.target(this.driver.getCurrentUrl()).request().acceptLanguage(new String[]{"en"}).get();
        Assert.assertTrue((boolean)((String)response.readEntity(String.class)).contains("Log in to test"));
    }
}

