/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.migration;

import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.migration.Migration;

public class MigrationTest
extends AbstractKeycloakTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.log.info((Object)"Adding no test realms for migration test. Test realm should be migrated from previous vesrion.");
    }

    @Test
    @Migration(versionFrom="1.6.1.Final")
    public void migration16Test() {
        RealmResource realmResource = this.adminClient.realms().realm("Migration");
        RealmRepresentation realmRep = realmResource.toRepresentation();
        Assert.assertEquals((Object)"Migration", (Object)realmRep.getRealm());
        List realmRoles = realmResource.roles().list();
        Assert.assertEquals((long)1L, (long)realmRoles.size());
        Assert.assertEquals((Object)"offline_access", (Object)((RoleRepresentation)realmRoles.get(0)).getName());
        block12: for (ClientRepresentation client : realmResource.clients().findAll()) {
            String clientId;
            switch (clientId = client.getClientId()) {
                case "realm-management": {
                    Assert.assertEquals((long)13L, (long)realmResource.clients().get(client.getId()).roles().list().size());
                    continue block12;
                }
                case "security-admin-console": {
                    Assert.assertEquals((long)0L, (long)realmResource.clients().get(client.getId()).roles().list().size());
                    continue block12;
                }
                case "broker": {
                    Assert.assertEquals((long)1L, (long)realmResource.clients().get(client.getId()).roles().list().size());
                    continue block12;
                }
                case "account": {
                    Assert.assertEquals((long)2L, (long)realmResource.clients().get(client.getId()).roles().list().size());
                    continue block12;
                }
            }
            Assert.fail((String)("Migrated realm contains unexpected client " + clientId));
        }
    }

    @Test
    @Migration(versionFrom="1.5.1.Final")
    @Ignore
    public void migration15Test() {
        for (RealmRepresentation realm : this.adminClient.realms().findAll()) {
            System.out.println(realm.getRealm());
        }
    }
}

