/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientTemplateResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.mappers.HardcodedClaim;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ProtocolMapperUtil;
import org.keycloak.testsuite.util.RealmManager;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.UserInfoClientUtil;
import org.keycloak.testsuite.util.UserManager;
import org.keycloak.util.BasicAuthHelper;

public class AccessTokenTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
        this.oauth.clientId("test-app");
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        UserBuilder user = UserBuilder.create().id(KeycloakModelUtils.generateId()).username("no-permissions").addRoles("user").password("password");
        realm.getUsers().add(user.build());
        testRealms.add(realm);
    }

    @Test
    public void accessTokenRequest() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertThat((Object)response.getExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(250)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(300))));
        Assert.assertThat((Object)response.getRefreshExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1750)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1800))));
        Assert.assertEquals((Object)"bearer", (Object)response.getTokenType());
        String expectedKid = this.oauth.doCertsRequest("test").getKeys()[0].getKeyId();
        JWSHeader header = new JWSInput(response.getAccessToken()).getHeader();
        Assert.assertEquals((Object)"RS256", (Object)header.getAlgorithm().name());
        Assert.assertEquals((Object)"JWT", (Object)header.getType());
        Assert.assertEquals((Object)expectedKid, (Object)header.getKeyId());
        Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getIdToken()).getHeader();
        Assert.assertEquals((Object)"RS256", (Object)header.getAlgorithm().name());
        Assert.assertEquals((Object)"JWT", (Object)header.getType());
        Assert.assertEquals((Object)expectedKid, (Object)header.getKeyId());
        Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getRefreshToken()).getHeader();
        Assert.assertEquals((Object)"RS256", (Object)header.getAlgorithm().name());
        Assert.assertEquals((Object)"JWT", (Object)header.getType());
        Assert.assertEquals((Object)expectedKid, (Object)header.getKeyId());
        Assert.assertNull((Object)header.getContentType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)ApiUtil.findUserByUsername(this.adminClient.realm("test"), "test-user@localhost").getId(), (Object)token.getSubject());
        Assert.assertNotEquals((Object)"test-user@localhost", (Object)token.getSubject());
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        Assert.assertEquals((long)1L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("user"));
        Assert.assertEquals((long)1L, (long)token.getResourceAccess(this.oauth.getClientId()).getRoles().size());
        Assert.assertTrue((boolean)token.getResourceAccess(this.oauth.getClientId()).isUserInRole("customer-user"));
        EventRepresentation event = this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        Assert.assertEquals((Object)token.getId(), event.getDetails().get("token_id"));
        Assert.assertEquals((Object)this.oauth.verifyRefreshToken(response.getRefreshToken()).getId(), event.getDetails().get("refresh_token_id"));
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
    }

    @Test
    public void accessTokenInvalidClientCredentials() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "invalid");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectCodeToToken(codeId, loginEvent.getSessionId()).error("invalid_client_credentials").clearDetails().user((String)null).session((String)null);
        expectedEvent.assertEvent();
    }

    @Test
    public void accessTokenMissingClientCredentials() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectCodeToToken(codeId, loginEvent.getSessionId()).error("invalid_client_credentials").clearDetails().user((String)null).session((String)null);
        expectedEvent.assertEvent();
    }

    @Test
    public void accessTokenInvalidRedirectUri() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        String redirectUri = this.oauth.getRedirectUri();
        this.oauth.redirectUri("http://invalid");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"Incorrect redirect_uri", (Object)response.getErrorDescription());
        this.events.expectCodeToToken(codeId, loginEvent.getSessionId()).error("invalid_code").removeDetail("token_id").removeDetail("refresh_token_id").removeDetail("refresh_token_type").assertEvent();
        this.oauth.redirectUri(redirectUri);
    }

    @Test
    public void accessTokenUserSessionExpired() {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String sessionId = loginEvent.getSessionId();
        this.testingClient.testing().removeUserSession("test", sessionId);
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        Assert.assertNull((Object)tokenResponse.getAccessToken());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        this.events.expectCodeToToken(codeId, sessionId).removeDetail("token_id").user((String)null).session((String)null).removeDetail("refresh_token_id").removeDetail("refresh_token_type").error("invalid_code").assertEvent();
        this.events.clear();
    }

    @Test
    public void accessTokenCodeExpired() {
        RealmManager.realm(this.adminClient.realm("test")).accessCodeLifeSpan(1);
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.setTimeOffset(2);
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        this.setTimeOffset(0);
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectCodeToToken(codeId, null);
        expectedEvent.error("invalid_code").removeDetail("token_id").removeDetail("refresh_token_id").removeDetail("refresh_token_type").user((String)null);
        expectedEvent.assertEvent();
        this.events.clear();
        RealmManager.realm(this.adminClient.realm("test")).accessCodeLifeSpan(60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void accessTokenCodeUsed() throws IOException {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        String accessToken = response.getAccessToken();
        try (Client jaxrsClient = javax.ws.rs.client.ClientBuilder.newClient();){
            Response userInfoResponse = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)jaxrsClient, (String)accessToken);
            UserInfoClientUtil.testSuccessfulUserInfoResponse((Response)userInfoResponse, (String)"test-user@localhost", (String)"test-user@localhost");
            String introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential("test-app", "password", accessToken);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(introspectionResponse);
            Assert.assertEquals((Object)true, (Object)jsonNode.get("active").asBoolean());
            Assert.assertEquals((Object)"test-user@localhost", (Object)jsonNode.get("email").asText());
            this.events.clear();
            response = this.oauth.doAccessTokenRequest(code, "password");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            AssertEvents.ExpectedEvent expectedEvent = this.events.expectCodeToToken(codeId, null);
            expectedEvent.error("invalid_code").removeDetail("token_id").removeDetail("refresh_token_id").removeDetail("refresh_token_type").user((String)null);
            expectedEvent.assertEvent();
            userInfoResponse = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)jaxrsClient, (String)accessToken);
            Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)userInfoResponse.getStatus());
            userInfoResponse.close();
            introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential("test-app", "password", accessToken);
            objectMapper = new ObjectMapper();
            jsonNode = objectMapper.readTree(introspectionResponse);
            Assert.assertEquals((Object)false, (Object)jsonNode.get("active").asBoolean());
            Assert.assertNull((Object)jsonNode.get("email"));
            this.events.clear();
            RealmManager.realm(this.adminClient.realm("test")).accessCodeLifeSpan(60);
        }
    }

    @Test
    public void accessTokenCodeRoleMissing() {
        RealmResource realmResource = this.adminClient.realm("test");
        RoleRepresentation role = RoleBuilder.create().name("tmp-role").build();
        realmResource.roles().create(role);
        UserResource user = ApiUtil.findUserByUsernameId(realmResource, "test-user@localhost");
        UserManager.realm(realmResource).user(user).assignRoles(role.getName());
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        realmResource.roles().deleteRole("tmp-role");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((long)1L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("user"));
        this.events.clear();
    }

    @Test
    public void accessTokenCodeHasRequiredAction() {
        UserResource user = ApiUtil.findUserByUsernameId(this.adminClient.realm("test"), "test-user@localhost");
        UserManager.realm(this.adminClient.realm("test")).user(user).addRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE.toString());
        this.oauth.doLogin("test-user@localhost", "password");
        String code = this.driver.getPageSource().split("code=")[1].split("&")[0].split("\"")[0];
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        EventRepresentation event = this.events.poll();
        Assert.assertNotNull(event.getDetails().get("code_id"));
        UserManager.realm(this.adminClient.realm("test")).user(user).removeRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE.toString());
    }

    @Test
    public void testGrantAccessToken() throws Exception {
        Client client = javax.ws.rs.client.ClientBuilder.newClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget grantTarget = client.target(grantUri);
        RealmResource realmsResource = this.adminClient.realm("test");
        RealmRepresentation realmRepresentation = realmsResource.toRepresentation();
        realmRepresentation.setSslRequired(SslRequired.ALL.toString());
        realmsResource.update(realmRepresentation);
        Response response = this.executeGrantAccessTokenRequest(grantTarget);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        response.close();
        RealmResource realmsResource2 = this.realmsResouce().realm("test");
        RealmRepresentation realmRepresentation2 = realmsResource2.toRepresentation();
        realmRepresentation2.setSslRequired(SslRequired.EXTERNAL.toString());
        realmsResource2.update(realmRepresentation2);
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        form.param("grant_type", "password");
        form.param("password", "password");
        Response response2 = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response2.getStatus());
        response2.close();
        header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        response2 = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response2.getStatus());
        response2.close();
        header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        form.param("password", "invalid");
        response2 = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response2.getStatus());
        response2.close();
        header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        response2 = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response2.getStatus());
        response2.close();
        ClientResource clientResource = ApiUtil.findClientByClientId(this.adminClient.realm("test"), "test-app");
        ClientRepresentation clientRepresentation = clientResource.toRepresentation();
        clientRepresentation.setBearerOnly(Boolean.valueOf(true));
        clientResource.update(clientRepresentation);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
        ClientResource clientResource2 = ApiUtil.findClientByClientId(this.adminClient.realm("test"), "test-app");
        ClientRepresentation clientRepresentation2 = clientResource2.toRepresentation();
        clientRepresentation2.setBearerOnly(Boolean.valueOf(false));
        clientResource2.update(clientRepresentation2);
        realmsResource = this.realmsResouce().realm("test");
        realmRepresentation = realmsResource.toRepresentation();
        realmRepresentation.setEnabled(Boolean.valueOf(false));
        realmsResource.update(realmRepresentation);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        response.close();
        realmsResource2 = this.realmsResouce().realm("test");
        realmRepresentation2 = realmsResource2.toRepresentation();
        realmRepresentation2.setEnabled(Boolean.valueOf(true));
        realmsResource2.update(realmRepresentation2);
        clientResource = ApiUtil.findClientByClientId(this.adminClient.realm("test"), "test-app");
        clientRepresentation = clientResource.toRepresentation();
        clientRepresentation.setEnabled(Boolean.valueOf(false));
        clientResource.update(clientRepresentation);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
        clientResource2 = ApiUtil.findClientByClientId(this.adminClient.realm("test"), "test-app");
        clientRepresentation2 = clientResource2.toRepresentation();
        clientRepresentation2.setEnabled(Boolean.valueOf(true));
        clientResource2.update(clientRepresentation2);
        UserResource userResource = ApiUtil.findUserByUsernameId(this.adminClient.realm("test"), "test-user@localhost");
        UserRepresentation userRepresentation = userResource.toRepresentation();
        userRepresentation.getRequiredActions().add(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        userResource.update(userRepresentation);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
        UserResource userResource2 = ApiUtil.findUserByUsernameId(this.adminClient.realm("test"), "test-user@localhost");
        UserRepresentation userRepresentation2 = userResource2.toRepresentation();
        userRepresentation2.getRequiredActions().remove(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        userResource2.update(userRepresentation2);
        userResource = ApiUtil.findUserByUsernameId(this.adminClient.realm("test"), "test-user@localhost");
        userRepresentation = userResource.toRepresentation();
        userRepresentation.setEnabled(Boolean.valueOf(false));
        userResource.update(userRepresentation);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
        userResource2 = ApiUtil.findUserByUsernameId(this.adminClient.realm("test"), "test-user@localhost");
        userRepresentation2 = userResource2.toRepresentation();
        userRepresentation2.setEnabled(Boolean.valueOf(true));
        userResource2.update(userRepresentation2);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        response.close();
        client.close();
        this.events.clear();
    }

    @Test
    public void testKeycloak2221() throws Exception {
        Client client = javax.ws.rs.client.ClientBuilder.newClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget grantTarget = client.target(grantUri);
        ClientResource clientResource = ApiUtil.findClientByClientId(this.adminClient.realm("test"), "test-app");
        clientResource.getProtocolMappers().createMapper(ProtocolMapperUtil.createRoleNameMapper("rename-role", "user", "realm-user"));
        clientResource.getProtocolMappers().createMapper(ProtocolMapperUtil.createRoleNameMapper("rename-role2", "admin", "the-admin"));
        Response response = this.executeGrantRequest(grantTarget, "no-permissions", "password");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        AccessToken accessToken = this.getAccessToken(tokenResponse);
        Assert.assertEquals((long)accessToken.getRealmAccess().getRoles().size(), (long)1L);
        Assert.assertTrue((boolean)accessToken.getRealmAccess().getRoles().contains("realm-user"));
        response.close();
        ClientResource app = ApiUtil.findClientByClientId(this.adminClient.realm("test"), "test-app");
        ClientRepresentation clientRepresentation = app.toRepresentation();
        for (ProtocolMapperRepresentation protocolRep : clientRepresentation.getProtocolMappers()) {
            if (!protocolRep.getName().startsWith("rename-role")) continue;
            clientResource.getProtocolMappers().delete(protocolRep.getId());
        }
        this.events.clear();
    }

    @Test
    public void testTokenMapping() throws Exception {
        Client client = javax.ws.rs.client.ClientBuilder.newClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget grantTarget = client.target(grantUri);
        UserResource userResource = ApiUtil.findUserByUsernameId(this.adminClient.realm("test"), "test-user@localhost");
        UserRepresentation user = userResource.toRepresentation();
        user.singleAttribute("street", "5 Yawkey Way");
        user.singleAttribute("locality", "Boston");
        user.singleAttribute("region", "MA");
        user.singleAttribute("postal_code", "02115");
        user.singleAttribute("country", "USA");
        user.singleAttribute("phone", "617-777-6666");
        List<String> departments = Arrays.asList("finance", "development");
        user.getAttributes().put("departments", departments);
        userResource.update(user);
        ClientResource app = ApiUtil.findClientResourceByClientId(this.adminClient.realm("test"), "test-app");
        ProtocolMapperRepresentation mapper = ProtocolMapperUtil.createAddressMapper(true, true);
        app.getProtocolMappers().createMapper(mapper);
        ProtocolMapperRepresentation hard = ProtocolMapperUtil.createHardcodedClaim("hard", "hard", "coded", "String", false, null, true, true);
        app.getProtocolMappers().createMapper(hard);
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createHardcodedClaim("hard-nested", "nested.hard", "coded-nested", "String", false, null, true, true));
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("custom phone", "phone", "home_phone", "String", true, "", true, true, false));
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("nested phone", "phone", "home.phone", "String", true, "", true, true, false));
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("departments", "departments", "department", "String", true, "", true, true, true));
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createHardcodedRole("hard-realm", "hardcoded"));
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createHardcodedRole("hard-app", "app.hardcoded"));
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createRoleNameMapper("rename-app-role", "test-app.customer-user", "realm-user"));
        Response response = this.executeGrantAccessTokenRequest(grantTarget);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        Object idToken = this.getIdToken(tokenResponse);
        Assert.assertNotNull((Object)idToken.getAddress());
        Assert.assertEquals((Object)idToken.getName(), (Object)"Tom Brady");
        Assert.assertEquals((Object)idToken.getAddress().getStreetAddress(), (Object)"5 Yawkey Way");
        Assert.assertEquals((Object)idToken.getAddress().getLocality(), (Object)"Boston");
        Assert.assertEquals((Object)idToken.getAddress().getRegion(), (Object)"MA");
        Assert.assertEquals((Object)idToken.getAddress().getPostalCode(), (Object)"02115");
        Assert.assertEquals((Object)idToken.getAddress().getCountry(), (Object)"USA");
        Assert.assertNotNull(idToken.getOtherClaims().get("home_phone"));
        Assert.assertEquals((Object)"617-777-6666", idToken.getOtherClaims().get("home_phone"));
        Assert.assertEquals((Object)"coded", idToken.getOtherClaims().get("hard"));
        Map nested = (Map)idToken.getOtherClaims().get("nested");
        Assert.assertEquals((Object)"coded-nested", nested.get("hard"));
        nested = (Map)idToken.getOtherClaims().get("home");
        Assert.assertEquals((Object)"617-777-6666", nested.get("phone"));
        List departments2 = (List)idToken.getOtherClaims().get("department");
        Assert.assertEquals((long)2L, (long)departments2.size());
        Assert.assertTrue((departments2.contains("finance") && departments2.contains("development") ? 1 : 0) != 0);
        AccessToken accessToken = this.getAccessToken(tokenResponse);
        Assert.assertEquals((Object)accessToken.getName(), (Object)"Tom Brady");
        Assert.assertNotNull((Object)accessToken.getAddress());
        Assert.assertEquals((Object)accessToken.getAddress().getStreetAddress(), (Object)"5 Yawkey Way");
        Assert.assertEquals((Object)accessToken.getAddress().getLocality(), (Object)"Boston");
        Assert.assertEquals((Object)accessToken.getAddress().getRegion(), (Object)"MA");
        Assert.assertEquals((Object)accessToken.getAddress().getPostalCode(), (Object)"02115");
        Assert.assertEquals((Object)accessToken.getAddress().getCountry(), (Object)"USA");
        Assert.assertNotNull(accessToken.getOtherClaims().get("home_phone"));
        Assert.assertEquals((Object)"617-777-6666", accessToken.getOtherClaims().get("home_phone"));
        Assert.assertEquals((Object)"coded", accessToken.getOtherClaims().get("hard"));
        nested = (Map)accessToken.getOtherClaims().get("nested");
        Assert.assertEquals((Object)"coded-nested", nested.get("hard"));
        nested = (Map)accessToken.getOtherClaims().get("home");
        Assert.assertEquals((Object)"617-777-6666", nested.get("phone"));
        departments2 = (List)idToken.getOtherClaims().get("department");
        Assert.assertEquals((long)2L, (long)departments2.size());
        Assert.assertTrue((departments2.contains("finance") && departments2.contains("development") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)accessToken.getRealmAccess().getRoles().contains("hardcoded"));
        Assert.assertTrue((boolean)accessToken.getRealmAccess().getRoles().contains("realm-user"));
        Assert.assertFalse((boolean)accessToken.getResourceAccess("test-app").getRoles().contains("customer-user"));
        Assert.assertTrue((boolean)accessToken.getResourceAccess("app").getRoles().contains("hardcoded"));
        response.close();
        ClientResource app2 = ApiUtil.findClientByClientId(this.adminClient.realm("test"), "test-app");
        ClientRepresentation clientRepresentation = app2.toRepresentation();
        for (ProtocolMapperRepresentation model : clientRepresentation.getProtocolMappers()) {
            if (!model.getName().equals("address") && !model.getName().equals("hard") && !model.getName().equals("hard-nested") && !model.getName().equals("custom phone") && !model.getName().equals("departments") && !model.getName().equals("nested phone") && !model.getName().equals("rename-app-role") && !model.getName().equals("hard-realm") && !model.getName().equals("hard-app")) continue;
            app2.getProtocolMappers().delete(model.getId());
        }
        this.events.clear();
        response = this.executeGrantAccessTokenRequest(grantTarget);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        idToken = this.getIdToken(tokenResponse);
        Assert.assertNull((Object)idToken.getAddress());
        Assert.assertNull(idToken.getOtherClaims().get("home_phone"));
        Assert.assertNull(idToken.getOtherClaims().get("hard"));
        Assert.assertNull(idToken.getOtherClaims().get("nested"));
        Assert.assertNull(idToken.getOtherClaims().get("department"));
        response.close();
        this.events.clear();
        client.close();
    }

    @Test
    public void testClientTemplate() throws Exception {
        RealmResource realm = this.adminClient.realm("test");
        RoleRepresentation realmRole = new RoleRepresentation();
        realmRole.setName("realm-test-role");
        realm.roles().create(realmRole);
        realmRole = realm.roles().get("realm-test-role").toRepresentation();
        RoleRepresentation realmRole2 = new RoleRepresentation();
        realmRole2.setName("realm-test-role2");
        realm.roles().create(realmRole2);
        realmRole2 = realm.roles().get("realm-test-role2").toRepresentation();
        List users = realm.users().search("test-user@localhost", Integer.valueOf(-1), Integer.valueOf(-1));
        Assert.assertEquals((long)1L, (long)users.size());
        UserRepresentation user = (UserRepresentation)users.get(0);
        LinkedList<RoleRepresentation> addRoles = new LinkedList<RoleRepresentation>();
        addRoles.add(realmRole);
        addRoles.add(realmRole2);
        realm.users().get(user.getId()).roles().realmLevel().add(addRoles);
        ClientTemplateRepresentation rep = new ClientTemplateRepresentation();
        rep.setName("template");
        rep.setProtocol("oidc");
        Response response = realm.clientTemplates().create(rep);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        URI templateUri = response.getLocation();
        response.close();
        ClientTemplateResource templateResource = (ClientTemplateResource)this.adminClient.proxy(ClientTemplateResource.class, templateUri);
        ProtocolMapperModel hard = HardcodedClaim.create((String)"hard", (String)"hard", (String)"coded", (String)"String", (boolean)false, null, (boolean)true, (boolean)true);
        ProtocolMapperRepresentation mapper = ModelToRepresentation.toRepresentation((ProtocolMapperModel)hard);
        response = templateResource.getProtocolMappers().createMapper(mapper);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        response.close();
        List clients = realm.clients().findAll();
        ClientRepresentation clientRep = null;
        for (ClientRepresentation c : clients) {
            if (!c.getClientId().equals("test-app")) continue;
            clientRep = c;
            break;
        }
        clientRep.setClientTemplate("template");
        clientRep.setFullScopeAllowed(Boolean.valueOf(false));
        clientRep.setUseTemplateMappers(Boolean.valueOf(true));
        clientRep.setUseTemplateScope(Boolean.valueOf(true));
        clientRep.setUseTemplateConfig(Boolean.valueOf(true));
        realm.clients().get(clientRep.getId()).update(clientRep);
        Client client = javax.ws.rs.client.ClientBuilder.newClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget grantTarget = client.target(grantUri);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        IDToken idToken = this.getIdToken(tokenResponse);
        Assert.assertEquals((Object)"coded", idToken.getOtherClaims().get("hard"));
        AccessToken accessToken = this.getAccessToken(tokenResponse);
        Assert.assertEquals((Object)"coded", accessToken.getOtherClaims().get("hard"));
        Assert.assertFalse((boolean)accessToken.getRealmAccess().getRoles().contains(realmRole.getName()));
        Assert.assertFalse((boolean)accessToken.getRealmAccess().getRoles().contains(realmRole2.getName()));
        response.close();
        client.close();
        LinkedList<RoleRepresentation> addRole1 = new LinkedList<RoleRepresentation>();
        addRole1.add(realmRole);
        templateResource.getScopeMappings().realmLevel().add(addRole1);
        Client client2 = javax.ws.rs.client.ClientBuilder.newClient();
        UriBuilder builder2 = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri2 = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder2).build(new Object[]{"test"});
        WebTarget grantTarget2 = client2.target(grantUri2);
        response = this.executeGrantAccessTokenRequest(grantTarget2);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse2 = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        accessToken = this.getAccessToken(tokenResponse2);
        Assert.assertNotNull((Object)accessToken.getRealmAccess());
        Assert.assertTrue((boolean)accessToken.getRealmAccess().getRoles().contains(realmRole.getName()));
        Assert.assertFalse((boolean)accessToken.getRealmAccess().getRoles().contains(realmRole2.getName()));
        response.close();
        client2.close();
        LinkedList<RoleRepresentation> addRole2 = new LinkedList<RoleRepresentation>();
        addRole2.add(realmRole2);
        realm.clients().get(clientRep.getId()).getScopeMappings().realmLevel().add(addRole2);
        Client client3 = javax.ws.rs.client.ClientBuilder.newClient();
        UriBuilder builder3 = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri3 = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder3).build(new Object[]{"test"});
        WebTarget grantTarget3 = client3.target(grantUri3);
        response = this.executeGrantAccessTokenRequest(grantTarget3);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse3 = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        AccessToken accessToken2 = this.getAccessToken(tokenResponse3);
        Assert.assertNotNull((Object)accessToken2.getRealmAccess());
        Assert.assertTrue((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole.getName()));
        Assert.assertTrue((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole2.getName()));
        response.close();
        client3.close();
        templateResource.getScopeMappings().realmLevel().remove(addRole1);
        realm.clients().get(clientRep.getId()).getScopeMappings().realmLevel().remove(addRole2);
        client3 = javax.ws.rs.client.ClientBuilder.newClient();
        builder3 = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        grantUri3 = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder3).build(new Object[]{"test"});
        grantTarget3 = client3.target(grantUri3);
        response = this.executeGrantAccessTokenRequest(grantTarget3);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        tokenResponse3 = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        accessToken2 = this.getAccessToken(tokenResponse3);
        Assert.assertFalse((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole.getName()));
        Assert.assertFalse((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole2.getName()));
        response.close();
        client3.close();
        rep.setFullScopeAllowed(Boolean.valueOf(true));
        templateResource.update(rep);
        client3 = javax.ws.rs.client.ClientBuilder.newClient();
        builder3 = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        grantUri3 = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder3).build(new Object[]{"test"});
        grantTarget3 = client3.target(grantUri3);
        response = this.executeGrantAccessTokenRequest(grantTarget3);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        tokenResponse3 = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        accessToken2 = this.getAccessToken(tokenResponse3);
        Assert.assertNotNull((Object)accessToken2.getRealmAccess());
        Assert.assertTrue((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole.getName()));
        Assert.assertTrue((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole2.getName()));
        response.close();
        client3.close();
        clientRep.setUseTemplateScope(Boolean.valueOf(false));
        realm.clients().get(clientRep.getId()).update(clientRep);
        client3 = javax.ws.rs.client.ClientBuilder.newClient();
        builder3 = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        grantUri3 = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder3).build(new Object[]{"test"});
        grantTarget3 = client3.target(grantUri3);
        response = this.executeGrantAccessTokenRequest(grantTarget3);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        tokenResponse3 = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        accessToken2 = this.getAccessToken(tokenResponse3);
        Assert.assertFalse((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole.getName()));
        Assert.assertFalse((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole2.getName()));
        response.close();
        client3.close();
        clientRep.setClientTemplate("NONE");
        clientRep.setFullScopeAllowed(Boolean.valueOf(true));
        realm.clients().get(clientRep.getId()).update(clientRep);
        realm.users().get(user.getId()).roles().realmLevel().remove(addRoles);
        realm.roles().get(realmRole.getName()).remove();
        realm.roles().get(realmRole2.getName()).remove();
        templateResource.remove();
        client3 = javax.ws.rs.client.ClientBuilder.newClient();
        builder3 = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        grantUri3 = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder3).build(new Object[]{"test"});
        grantTarget3 = client3.target(grantUri3);
        response = this.executeGrantAccessTokenRequest(grantTarget3);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        tokenResponse3 = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        IDToken idToken2 = this.getIdToken(tokenResponse3);
        Assert.assertNull(idToken2.getOtherClaims().get("hard"));
        AccessToken accessToken3 = this.getAccessToken(tokenResponse3);
        Assert.assertNull(accessToken3.getOtherClaims().get("hard"));
        response.close();
        client3.close();
        this.events.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthorizationNegotiateHeaderIgnored() throws Exception {
        this.adminClient.realm("test").clients().create(ClientBuilder.create().clientId("sample-public-client").authenticatorType("client-secret").redirectUris("http://localhost:8180/auth/realms/master/app/*").publicClient().build());
        this.oauth.clientId("sample-public-client");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("sample-public-client").assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpPost post = new HttpPost(this.oauth.getAccessTokenUrl());
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
            parameters.add(new BasicNameValuePair("code", code));
            parameters.add(new BasicNameValuePair("redirect_uri", this.oauth.getRedirectUri()));
            parameters.add(new BasicNameValuePair("client_id", this.oauth.getClientId()));
            post.setHeader("Authorization", "Negotiate something-which-will-be-ignored");
            UrlEncodedFormEntity formEntity = null;
            formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            post.setEntity((HttpEntity)formEntity);
            OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse((HttpResponse)client.execute((HttpUriRequest)post));
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            AccessToken token = this.oauth.verifyToken(response.getAccessToken());
            this.events.expectCodeToToken(codeId, sessionId).client("sample-public-client").assertEvent();
        }
        finally {
            this.oauth.closeClient((CloseableHttpClient)client);
        }
    }

    private IDToken getIdToken(AccessTokenResponse tokenResponse) throws JWSInputException {
        JWSInput input = new JWSInput(tokenResponse.getIdToken());
        return (IDToken)input.readJsonContent(IDToken.class);
    }

    private AccessToken getAccessToken(AccessTokenResponse tokenResponse) throws JWSInputException {
        JWSInput input = new JWSInput(tokenResponse.getToken());
        return (AccessToken)input.readJsonContent(AccessToken.class);
    }

    protected Response executeGrantAccessTokenRequest(WebTarget grantTarget) {
        String username = "test-user@localhost";
        String password = "password";
        return this.executeGrantRequest(grantTarget, username, password);
    }

    protected Response executeGrantRequest(WebTarget grantTarget, String username, String password) {
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        form.param("grant_type", "password").param("username", username).param("password", password);
        return grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
    }
}

