/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.By;

public class AuthorizationCodeTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected ErrorPage errorPage;

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realmRepresentation);
    }

    @Before
    public void clientConfiguration() {
        this.oauth.responseType("code");
        this.oauth.responseMode(null);
    }

    @Test
    public void authorizationRequest() throws IOException {
        this.oauth.state("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertTrue((boolean)response.isRedirected());
        Assert.assertNotNull((Object)response.getCode());
        Assert.assertEquals((Object)"OpenIdConnect.AuthenticationProperties=2302984sdlk", (Object)response.getState());
        Assert.assertNull((Object)response.getError());
        this.testingClient.testing().verifyCode("test", response.getCode());
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
        this.assertCode(codeId, response.getCode());
    }

    @Test
    public void authorizationRequestInstalledApp() throws IOException {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("urn:ietf:wg:oauth:2.0:oob");
        this.oauth.redirectUri("urn:ietf:wg:oauth:2.0:oob");
        this.oauth.doLogin("test-user@localhost", "password");
        String title = this.driver.getTitle();
        Assert.assertEquals((Object)"Success code", (Object)title);
        String code = this.driver.findElement(By.id((String)"code")).getAttribute("value");
        this.testingClient.testing().verifyCode("test", code);
        String codeId = (String)this.events.expectLogin().detail("redirect_uri", "http://localhost:8180/auth/realms/test/protocol/openid-connect/oauth/oob").assertEvent().getDetails().get("code_id");
        this.assertCode(codeId, code);
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").removeRedirectUris("urn:ietf:wg:oauth:2.0:oob");
    }

    @Test
    public void authorizationValidRedirectUri() throws IOException {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris(this.oauth.getRedirectUri());
        this.oauth.state("mystate");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertTrue((boolean)response.isRedirected());
        Assert.assertNotNull((Object)response.getCode());
        this.testingClient.testing().verifyCode("test", response.getCode());
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
        this.assertCode(codeId, response.getCode());
    }

    @Test
    public void authorizationRequestNoState() throws IOException {
        this.oauth.state(null);
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertTrue((boolean)response.isRedirected());
        Assert.assertNotNull((Object)response.getCode());
        Assert.assertNull((Object)response.getState());
        Assert.assertNull((Object)response.getError());
        this.testingClient.testing().verifyCode("test", response.getCode());
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
        this.assertCode(codeId, response.getCode());
    }

    @Test
    public void authorizationRequestImplicitFlowDisabled() throws IOException {
        this.oauth.responseType("token id_token");
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth, true);
        Assert.assertTrue((boolean)errorResponse.isRedirected());
        Assert.assertEquals((Object)errorResponse.getError(), (Object)"unsupported_response_type");
        Assert.assertEquals((Object)errorResponse.getErrorDescription(), (Object)"Client is not allowed to initiate browser login with given response_type. Implicit flow is disabled for the client.");
        this.events.expectLogin().error("not_allowed").user((String)null).session((String)null).clearDetails().detail("response_type", "token id_token").assertEvent();
    }

    @Test
    public void authorizationRequestMissingResponseType() throws IOException {
        this.oauth.responseType(null);
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertTrue((boolean)errorResponse.isRedirected());
        Assert.assertEquals((Object)errorResponse.getError(), (Object)"invalid_request");
        this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
    }

    @Test
    public void authorizationRequestInvalidResponseType() throws IOException {
        this.oauth.responseType("tokenn");
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertTrue((boolean)errorResponse.isRedirected());
        Assert.assertEquals((Object)errorResponse.getError(), (Object)"unsupported_response_type");
        this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().detail("response_type", "tokenn").assertEvent();
    }

    @Test
    public void authorizationRequestFormPostResponseMode() throws IOException {
        this.oauth.responseMode(OIDCResponseMode.FORM_POST.toString().toLowerCase());
        this.oauth.state("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        this.oauth.doLoginGrant("test-user@localhost", "password");
        String sources = this.driver.getPageSource();
        System.out.println(sources);
        String code = this.driver.findElement(By.id((String)"code")).getText();
        String state = this.driver.findElement(By.id((String)"state")).getText();
        Assert.assertEquals((Object)"OpenIdConnect.AuthenticationProperties=2302984sdlk", (Object)state);
        this.testingClient.testing().verifyCode("test", code);
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
        this.assertCode(codeId, code);
    }

    private void assertCode(String expectedCodeId, String actualCode) {
        String code = this.testingClient.testing().verifyCode("test", actualCode);
        Assert.assertEquals((Object)expectedCodeId, (Object)code);
    }
}

