/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.OAuthClient;

public class ClientAuthPostMethodTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void testPostAuthentication() {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.doAccessTokenRequestPostAuth(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertThat((Object)response.getExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(250)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(300))));
        Assert.assertThat((Object)response.getRefreshExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1750)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1800))));
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        EventRepresentation event = this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        Assert.assertEquals((Object)token.getId(), event.getDetails().get("token_id"));
        Assert.assertEquals((Object)this.oauth.verifyRefreshToken(response.getRefreshToken()).getId(), event.getDetails().get("refresh_token_id"));
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
    }

    private OAuthClient.AccessTokenResponse doAccessTokenRequestPostAuth(String code, String clientSecret) {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.oauth.getAccessTokenUrl());
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
            parameters.add(new BasicNameValuePair("code", code));
            parameters.add(new BasicNameValuePair("redirect_uri", this.oauth.getRedirectUri()));
            parameters.add(new BasicNameValuePair("client_id", this.oauth.getClientId()));
            parameters.add(new BasicNameValuePair("client_secret", clientSecret));
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            try {
                OAuthClient.AccessTokenResponse e = new OAuthClient.AccessTokenResponse((HttpResponse)client.execute((HttpUriRequest)post));
                return e;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to retrieve access token", e);
            }
        }
        finally {
            this.oauth.closeClient((CloseableHttpClient)client);
        }
    }
}

