/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.authentication.JWTClientCredentialsProvider;
import org.keycloak.admin.client.resource.ClientAttributeCertificateResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.common.util.BouncyIntegration;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.KeyStoreConfig;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class ClientAuthSignedJWTTest
extends AbstractKeycloakTest {
    public static final String CERTIFICATE_PEM = "Certificate PEM";
    @Rule
    public AssertEvents events = new AssertEvents(this);
    private String client1SAUserId;
    private RealmRepresentation testRealm;
    private ClientRepresentation app1;
    private ClientRepresentation app2;
    private ClientRepresentation app3;
    private UserRepresentation defaultUser;
    private UserRepresentation serviceAccountUser;

    @BeforeClass
    public static void beforeClientAuthSignedJWTTest() {
        BouncyIntegration.init();
    }

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder realmBuilder = RealmBuilder.create().name("test").privateKey("MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=").publicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB").testEventListener();
        this.app1 = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("client1").attribute("jwt.credential.certificate", "MIICnTCCAYUCBgFPPLDaTzANBgkqhkiG9w0BAQsFADASMRAwDgYDVQQDDAdjbGllbnQxMB4XDTE1MDgxNzE3MjI0N1oXDTI1MDgxNzE3MjQyN1owEjEQMA4GA1UEAwwHY2xpZW50MTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIUjjgv+V3s96O+Za9002Lp/trtGuHBeaeVL9dFKMKzO2MPqdRmHB4PqNlDdd28Rwf5Xn6iWdFpyUKOnI/yXDLhdcuFpR0sMNK/C9Lt+hSpPFLuzDqgtPgDotlMxiHIWDOZ7g9/gPYNXbNvjv8nSiyqoguoCQiiafW90bPHsiVLdP7ZIUwCcfi1qQm7FhxRJ1NiW5dvUkuCnnWEf0XR+Wzc5eC9EgB0taLFiPsSEIlWMm5xlahYyXkPdNOqZjiRnrTWm5Y4uk8ZcsD/KbPTf/7t7cQXipVaswgjdYi1kK2/zRwOhg1QwWFX/qmvdd+fLxV0R6VqRDhn7Qep2cxwMxLsCAwEAATANBgkqhkiG9w0BAQsFAAOCAQEAKE6OA46sf20bz8LZPoiNsqRwBUDkaMGXfnob7s/hJZIIwDEx0IAQ3uKsG7q9wb+aA6s+v7S340zb2k3IxuhFaHaZpAd4CyR5cn1FHylbzoZ7rI/3ASqHDqpljdJaFqPH+m7nZWtyDvtZf+gkZ8OjsndwsSBK1d/jMZPp29qYbl1+XfO7RCp/jDqro/R3saYFaIFiEZPeKn1hUJn6BO48vxH1xspSu9FmlvDOEAOz4AuM58z4zRMP49GcFdCWr1wkonJUHaSptJaQwmBwLFUkCbE5I1ixGMb7mjEud6Y5jhfzJiZMo2U8RfcjNbrN0diZl3jB6LQIwESnhYSghaTjNQ==").authenticatorType("client-jwt").serviceAccountsEnabled(true).build();
        realmBuilder.client(this.app1);
        this.app2 = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("client2").directAccessGrants().serviceAccountsEnabled(true).redirectUris(OAuthClient.APP_ROOT + "/auth").attribute("jwt.credential.certificate", "MIICnTCCAYUCBgFPPQDGxTANBgkqhkiG9w0BAQsFADASMRAwDgYDVQQDDAdjbGllbnQxMB4XDTE1MDgxNzE4NTAwNVoXDTI1MDgxNzE4NTE0NVowEjEQMA4GA1UEAwwHY2xpZW50MTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMMw3PaBffWxgS2PYSDDBp6As+cNvv9kt2C4f/RDAGmvSIHPFev9kuQiKs3Oaws3ZsV4JG3qHEuYgnh9W4vfe3DwNwtD1bjL5FYBhPBFTw0lAQECYxaBHnkjHwUKp957FqdSPPICm3LjmTcEdlH+9dpp9xHCMbbiNiWDzWI1xSxC8Fs2d0hwz1sd+Q4QeTBPIBWcPM+ICZtNG5MN+ORfayu4X+Me5d0tXG2fQO//rAevk1i5IFjKZuOjTwyKB5SJIY4b8QTeg0g/50IU7Ht00Pxw6CK02dHS+FvXHasZlD3ckomqCDjStTBWdhJo5dST0CbOqalkkpLlCCbGA1yEQRsCAwEAATANBgkqhkiG9w0BAQsFAAOCAQEAUIMeJ+EAo8eNpCG/nXImacjrKakbFnZYBGD/gqeTGaZynkX+jgBSructTHR83zSH+yELEhsAy+3BfK4EEihp+PEcRnK2fASVkHste8AQ7rlzC+HGGirlwrVhWCdizNUCGK80DE537IZ7nmZw6LFG9P5/Q2MvCsOCYjRUvMkukq6TdXBXR9tETwZ+0gpSfsOxjj0ZF7ftTRUSzx4rFfcbM9fRNdVizdOuKGc8HJPA5lLOxV6CyaYIvi3y5RlQI1OHeS34lE4w9CNPRFa/vdxXvN7ClyzA0HMFNWxBN7pC/Ht/FbhSvaAagJBHg+vCrcY5C26Oli7lAglf/zZrwUPs0w==").authenticatorType("client-jwt").build();
        realmBuilder.client(this.app2);
        this.app3 = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("client3").directAccessGrants().authenticatorType("client-jwt").build();
        realmBuilder.client(this.app3);
        this.defaultUser = UserBuilder.create().id(KeycloakModelUtils.generateId()).serviceAccountId(this.app1.getClientId()).username("test-user@localhost").password("password").build();
        realmBuilder.user(this.defaultUser);
        this.client1SAUserId = KeycloakModelUtils.generateId();
        this.serviceAccountUser = UserBuilder.create().id(this.client1SAUserId).username("service-account-" + this.app1.getClientId()).serviceAccountId(this.app1.getClientId()).build();
        realmBuilder.user(this.serviceAccountUser);
        this.testRealm = realmBuilder.build();
        testRealms.add(this.testRealm);
    }

    @Test
    public void testServiceAccountAndLogoutSuccess() throws Exception {
        String client1Jwt = this.getClient1SignedJWT();
        OAuthClient.AccessTokenResponse response = this.doClientCredentialsGrantRequest(client1Jwt);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(response.getRefreshToken());
        this.events.expectClientLogin().client("client1").user(this.client1SAUserId).session(accessToken.getSessionState()).detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", "service-account-client1").detail("client_auth_method", "client-jwt").assertEvent();
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshToken.getSessionState());
        client1Jwt = this.getClient1SignedJWT();
        OAuthClient.AccessTokenResponse refreshedResponse = this.doRefreshTokenRequest(response.getRefreshToken(), client1Jwt);
        AccessToken refreshedAccessToken = this.oauth.verifyToken(refreshedResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.verifyRefreshToken(refreshedResponse.getRefreshToken());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedAccessToken.getSessionState());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedRefreshToken.getSessionState());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).user(this.client1SAUserId).client("client1").detail("client_auth_method", "client-jwt").assertEvent();
        HttpResponse logoutResponse = this.doLogout(response.getRefreshToken(), this.getClient1SignedJWT());
        Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
        this.events.expectLogout(accessToken.getSessionState()).client("client1").user(this.client1SAUserId).removeDetail("redirect_uri").detail("client_auth_method", "client-jwt").assertEvent();
        response = this.doRefreshTokenRequest(response.getRefreshToken(), this.getClient1SignedJWT());
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).client("client1").user(this.client1SAUserId).removeDetail("token_id").removeDetail("updated_refresh_token_id").detail("client_auth_method", "client-jwt").error("invalid_token").assertEvent();
    }

    @Test
    public void testCodeToTokenRequestSuccess() throws Exception {
        this.oauth.clientId("client2");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("client2").assertEvent();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.doAccessTokenRequest(code, this.getClient2SignedJWT());
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.oauth.verifyToken(response.getAccessToken());
        this.oauth.verifyRefreshToken(response.getRefreshToken());
        this.events.expectCodeToToken((String)loginEvent.getDetails().get("code_id"), loginEvent.getSessionId()).client("client2").detail("client_auth_method", "client-jwt").assertEvent();
    }

    @Test
    public void testDirectGrantRequestSuccess() throws Exception {
        this.oauth.clientId("client2");
        OAuthClient.AccessTokenResponse response = this.doGrantAccessTokenRequest("test-user@localhost", "password", this.getClient2SignedJWT());
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(response.getRefreshToken());
        this.events.expectLogin().client("client2").session(accessToken.getSessionState()).detail("grant_type", "password").detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", "test-user@localhost").detail("client_auth_method", "client-jwt").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
    }

    @Test
    public void testClientWithGeneratedKeysJKS() throws Exception {
        this.testClientWithGeneratedKeys("JKS");
    }

    @Test
    public void testClientWithGeneratedKeysPKCS12() throws Exception {
        this.testClientWithGeneratedKeys("PKCS12");
    }

    private void testClientWithGeneratedKeys(String format) throws Exception {
        ClientRepresentation client = this.app3;
        UserRepresentation user = this.defaultUser;
        String keyAlias = "somekey";
        String keyPassword = "pwd1";
        String storePassword = "pwd2";
        KeyStoreConfig keyStoreConfig = new KeyStoreConfig();
        keyStoreConfig.setFormat(format);
        keyStoreConfig.setKeyPassword("pwd1");
        keyStoreConfig.setStorePassword("pwd2");
        keyStoreConfig.setKeyAlias("somekey");
        client = this.getClient(this.testRealm.getRealm(), client.getId()).toRepresentation();
        String certOld = (String)client.getAttributes().get("jwt.credential.certificate");
        byte[] keyStoreBytes = this.getClientAttributeCertificateResource(this.testRealm.getRealm(), client.getId()).generateAndGetKeystore(keyStoreConfig);
        ByteArrayInputStream keyStoreIs = new ByteArrayInputStream(keyStoreBytes);
        KeyStore keyStore = ClientAuthSignedJWTTest.getKeystore(keyStoreIs, "pwd2", format);
        keyStoreIs.close();
        client = this.getClient(this.testRealm.getRealm(), client.getId()).toRepresentation();
        ClientAuthSignedJWTTest.assertCertificate(client, certOld, KeycloakModelUtils.getPemFromCertificate((X509Certificate)((X509Certificate)keyStore.getCertificate("somekey"))));
        this.oauth.clientId(client.getClientId());
        PrivateKey privateKey = (PrivateKey)keyStore.getKey("somekey", "pwd1".toCharArray());
        OAuthClient.AccessTokenResponse response = this.doGrantAccessTokenRequest(user.getUsername(), ((CredentialRepresentation)user.getCredentials().get(0)).getValue(), this.getClientSignedJWT(privateKey, client.getClientId()));
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(response.getRefreshToken());
        this.events.expectLogin().client(client.getClientId()).session(accessToken.getSessionState()).detail("grant_type", "password").detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", user.getUsername()).detail("client_auth_method", "client-jwt").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
    }

    @Test
    public void testUploadKeystoreJKS() throws Exception {
        this.testUploadKeystore("JKS", "client-auth-test/keystore-client1.jks", "clientkey", "storepass");
    }

    @Test
    public void testUploadKeystorePKCS12() throws Exception {
        this.testUploadKeystore("PKCS12", "client-auth-test/keystore-client2.p12", "clientkey", "pwd2");
    }

    @Test
    public void testUploadPEM() throws Exception {
        this.testUploadKeystore(CERTIFICATE_PEM, "client-auth-test/certificate.pem", "undefined", "undefined");
    }

    private void testUploadKeystore(String keystoreFormat, String filePath, String keyAlias, String storePassword) throws Exception {
        String pem;
        ClientRepresentation client = this.getClient(this.testRealm.getRealm(), this.app3.getId()).toRepresentation();
        String certOld = (String)client.getAttributes().get("jwt.credential.certificate");
        URL fileUrl = this.getClass().getClassLoader().getResource(filePath);
        if (fileUrl == null) {
            throw new IOException("File not found: " + filePath);
        }
        File keystoreFile = new File(fileUrl.getFile());
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doGrantAccessTokenRequest("master", "admin", "admin", null, "admin-cli", null);
        Assert.assertEquals((long)200L, (long)accessTokenResponse.getStatusCode());
        String url = this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/admin/realms/" + this.testRealm.getRealm() + "/clients/" + client.getId() + "/certificates/jwt.credential/upload-certificate";
        FileBody fileBody = new FileBody(keystoreFile);
        HttpEntity entity = MultipartEntityBuilder.create().addPart("file", (ContentBody)fileBody).addTextBody("keystoreFormat", keystoreFormat).addTextBody("keyAlias", keyAlias).addTextBody("storePassword", storePassword).addTextBody("keyPassword", "undefined").build();
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Authorization", "Bearer " + accessTokenResponse.getAccessToken());
        httpRequest.setEntity(entity);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
        Assert.assertEquals((long)200L, (long)httpResponse.getStatusLine().getStatusCode());
        client = this.getClient(this.testRealm.getRealm(), client.getId()).toRepresentation();
        if (!keystoreFormat.equals(CERTIFICATE_PEM)) {
            FileInputStream keystoreIs = new FileInputStream(keystoreFile);
            KeyStore keyStore = ClientAuthSignedJWTTest.getKeystore(keystoreIs, storePassword, keystoreFormat);
            ((InputStream)keystoreIs).close();
            pem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)((X509Certificate)keyStore.getCertificate(keyAlias)));
        } else {
            pem = new String(Files.readAllBytes(keystoreFile.toPath()));
        }
        ClientAuthSignedJWTTest.assertCertificate(client, certOld, pem);
    }

    @Test
    public void testMissingClientAssertionType() throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        HttpResponse resp = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(resp);
        this.assertError(response, null, "unauthorized_client", "invalid_client_credentials");
    }

    @Test
    public void testInvalidClientAssertionType() throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "invalid"));
        HttpResponse resp = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(resp);
        this.assertError(response, null, "unauthorized_client", "invalid_client_credentials");
    }

    @Test
    public void testMissingClientAssertion() throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        HttpResponse resp = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(resp);
        this.assertError(response, null, "unauthorized_client", "invalid_client_credentials");
    }

    @Test
    public void testAssertionMissingIssuer() throws Exception {
        String invalidJwt = this.getClientSignedJWT(this.getClient1PrivateKey(), null);
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", invalidJwt));
        HttpResponse resp = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(resp);
        this.assertError(response, null, "unauthorized_client", "invalid_client_credentials");
    }

    @Test
    public void testAssertionUnknownClient() throws Exception {
        String invalidJwt = this.getClientSignedJWT(this.getClient1PrivateKey(), "unknown-client");
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", invalidJwt));
        HttpResponse resp = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(resp);
        this.assertError(response, "unknown-client", "unauthorized_client", "invalid_client_credentials");
    }

    @Test
    public void testAssertionDisabledClient() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("client1").enabled(false);
        String invalidJwt = this.getClient1SignedJWT();
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", invalidJwt));
        HttpResponse resp = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(resp);
        this.assertError(response, "client1", "invalid_client", "client_disabled");
        ClientManager.realm(this.adminClient.realm("test")).clientId("client1").enabled(false);
    }

    @Test
    public void testAssertionUnconfiguredClientCertificate() throws Exception {
        class CertificateHolder {
            String certificate;

            CertificateHolder() {
            }
        }
        CertificateHolder backupClient1Cert = new CertificateHolder();
        backupClient1Cert.certificate = (String)ApiUtil.findClientByClientId(this.adminClient.realm("test"), "client1").toRepresentation().getAttributes().get("jwt.credential.certificate");
        ClientManager.realm(this.adminClient.realm("test")).clientId("client1").updateAttribute("jwt.credential.certificate", null);
        String invalidJwt = this.getClient1SignedJWT();
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", invalidJwt));
        HttpResponse resp = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(resp);
        this.assertError(response, "client1", "unauthorized_client", "client_credentials_setup_required");
        ClientManager.realm(this.adminClient.realm("test")).clientId("client1").updateAttribute("jwt.credential.certificate", backupClient1Cert.certificate);
    }

    @Test
    public void testAssertionInvalidSignature() throws Exception {
        String invalidJwt = this.getClientSignedJWT(this.getClient2PrivateKey(), "client1");
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", invalidJwt));
        HttpResponse resp = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(resp);
        this.assertError(response, "client1", "unauthorized_client", "invalid_client_credentials");
    }

    @Test
    public void testAssertionExpired() throws Exception {
        String invalidJwt = this.getClient1SignedJWT();
        this.setTimeOffset(1000);
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", invalidJwt));
        HttpResponse resp = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(resp);
        this.setTimeOffset(0);
        this.assertError(response, "client1", "unauthorized_client", "invalid_client_credentials");
    }

    @Test
    public void testAssertionInvalidNotBefore() throws Exception {
        String invalidJwt = this.getClient1SignedJWT();
        this.setTimeOffset(-1000);
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", invalidJwt));
        HttpResponse resp = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(resp);
        this.setTimeOffset(0);
        this.assertError(response, "client1", "unauthorized_client", "invalid_client_credentials");
    }

    @Test
    public void testMissingIdClaim() throws Exception {
        OAuthClient.AccessTokenResponse response = this.testMissingClaim("id");
        this.assertSuccess(response, this.app1.getClientId(), this.serviceAccountUser.getId(), this.serviceAccountUser.getUsername());
    }

    @Test
    public void testMissingIssuerClaim() throws Exception {
        OAuthClient.AccessTokenResponse response = this.testMissingClaim("issuer");
        this.assertSuccess(response, this.app1.getClientId(), this.serviceAccountUser.getId(), this.serviceAccountUser.getUsername());
    }

    @Test
    public void testMissingSubjectClaim() throws Exception {
        OAuthClient.AccessTokenResponse response = this.testMissingClaim("subject");
        this.assertError(response, null, "unauthorized_client", "invalid_client_credentials");
    }

    @Test
    public void testMissingAudienceClaim() throws Exception {
        OAuthClient.AccessTokenResponse response = this.testMissingClaim("audience");
        this.assertError(response, this.app1.getClientId(), "unauthorized_client", "invalid_client_credentials");
    }

    @Test
    public void testMissingIssuedAtClaim() throws Exception {
        OAuthClient.AccessTokenResponse response = this.testMissingClaim("issuedAt");
        this.assertSuccess(response, this.app1.getClientId(), this.serviceAccountUser.getId(), this.serviceAccountUser.getUsername());
    }

    @Test
    public void testMissingExpirationClaim() throws Exception {
        OAuthClient.AccessTokenResponse response = this.testMissingClaim("expiration");
        this.assertSuccess(response, this.app1.getClientId(), this.serviceAccountUser.getId(), this.serviceAccountUser.getUsername());
        response = this.testMissingClaim(-11, "expiration");
        this.assertError(response, this.app1.getClientId(), "unauthorized_client", "invalid_client_credentials");
        response = this.testMissingClaim("expiration", "issuedAt");
        this.assertError(response, this.app1.getClientId(), "unauthorized_client", "invalid_client_credentials");
    }

    @Test
    public void testMissingNotBeforeClaim() throws Exception {
        OAuthClient.AccessTokenResponse response = this.testMissingClaim("notBefore");
        this.assertSuccess(response, this.app1.getClientId(), this.serviceAccountUser.getId(), this.serviceAccountUser.getUsername());
    }

    private OAuthClient.AccessTokenResponse testMissingClaim(String ... claims) throws Exception {
        return this.testMissingClaim(0, claims);
    }

    private OAuthClient.AccessTokenResponse testMissingClaim(int tokenTimeOffset, String ... claims) throws Exception {
        CustomJWTClientCredentialsProvider jwtProvider = new CustomJWTClientCredentialsProvider();
        jwtProvider.setPrivateKey(this.getClient1PrivateKey());
        jwtProvider.setTokenTimeout(10);
        for (String claim : claims) {
            jwtProvider.enableClaim(claim, false);
        }
        Time.setOffset((int)tokenTimeOffset);
        String jwt = jwtProvider.createSignedRequestToken(this.app1.getClientId(), this.getRealmInfoUrl());
        Time.setOffset((int)0);
        return this.doClientCredentialsGrantRequest(jwt);
    }

    private void assertError(OAuthClient.AccessTokenResponse response, String clientId, String responseError, String eventError) {
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)responseError, (Object)response.getError());
        this.events.expectClientLogin().client(clientId).session((String)null).clearDetails().error(eventError).user((String)null).assertEvent();
    }

    private void assertSuccess(OAuthClient.AccessTokenResponse response, String clientId, String userId, String userName) {
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(response.getRefreshToken());
        this.events.expectClientLogin().client(clientId).user(userId).session(accessToken.getSessionState()).detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", userName).detail("client_auth_method", "client-jwt").assertEvent();
    }

    private static void assertCertificate(ClientRepresentation client, String certOld, String pem) {
        String certNew = (String)client.getAttributes().get("jwt.credential.certificate");
        Assert.assertNotEquals((String)"The old and new certificates shouldn't match", (Object)certOld, (Object)certNew);
        Assert.assertEquals((String)"Certificates don't match", (Object)pem, (Object)certNew);
    }

    private OAuthClient.AccessTokenResponse doAccessTokenRequest(String code, String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        parameters.add((NameValuePair)new BasicNameValuePair("code", code));
        parameters.add((NameValuePair)new BasicNameValuePair("redirect_uri", this.oauth.getRedirectUri()));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        HttpResponse response = this.sendRequest(this.oauth.getAccessTokenUrl(), parameters);
        return new OAuthClient.AccessTokenResponse(response);
    }

    private OAuthClient.AccessTokenResponse doRefreshTokenRequest(String refreshToken, String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "refresh_token"));
        parameters.add((NameValuePair)new BasicNameValuePair("refresh_token", refreshToken));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        HttpResponse response = this.sendRequest(this.oauth.getRefreshTokenUrl(), parameters);
        return new OAuthClient.AccessTokenResponse(response);
    }

    private HttpResponse doLogout(String refreshToken, String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "refresh_token"));
        parameters.add((NameValuePair)new BasicNameValuePair("refresh_token", refreshToken));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        return this.sendRequest(this.oauth.getLogoutUrl(null, null), parameters);
    }

    private OAuthClient.AccessTokenResponse doClientCredentialsGrantRequest(String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        HttpResponse response = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        return new OAuthClient.AccessTokenResponse(response);
    }

    private OAuthClient.AccessTokenResponse doGrantAccessTokenRequest(String username, String password, String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "password"));
        parameters.add((NameValuePair)new BasicNameValuePair("username", username));
        parameters.add((NameValuePair)new BasicNameValuePair("password", password));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        HttpResponse response = this.sendRequest(this.oauth.getResourceOwnerPasswordCredentialGrantUrl(), parameters);
        return new OAuthClient.AccessTokenResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse sendRequest(String requestUrl, List<NameValuePair> parameters) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpPost post = new HttpPost(requestUrl);
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            post.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)post);
            return closeableHttpResponse;
        }
        finally {
            this.oauth.closeClient((CloseableHttpClient)client);
        }
    }

    private String getClient1SignedJWT() {
        return this.getClientSignedJWT(this.getClient1PrivateKey(), "client1");
    }

    private String getClient2SignedJWT() {
        return this.getClientSignedJWT(this.getClient2PrivateKey(), "client2");
    }

    private PrivateKey getClient1PrivateKey() {
        return KeystoreUtil.loadPrivateKeyFromKeystore((String)"classpath:client-auth-test/keystore-client1.jks", (String)"storepass", (String)"keypass", (String)"clientkey", (KeystoreUtil.KeystoreFormat)KeystoreUtil.KeystoreFormat.JKS);
    }

    private PrivateKey getClient2PrivateKey() {
        return KeystoreUtil.loadPrivateKeyFromKeystore((String)"classpath:client-auth-test/keystore-client2.jks", (String)"storepass", (String)"keypass", (String)"clientkey", (KeystoreUtil.KeystoreFormat)KeystoreUtil.KeystoreFormat.JKS);
    }

    private String getClientSignedJWT(PrivateKey privateKey, String clientId) {
        JWTClientCredentialsProvider jwtProvider = new JWTClientCredentialsProvider();
        jwtProvider.setPrivateKey(privateKey);
        jwtProvider.setTokenTimeout(10);
        return jwtProvider.createSignedRequestToken(clientId, this.getRealmInfoUrl());
    }

    private String getRealmInfoUrl() {
        String authServerBaseUrl = UriUtils.getOrigin((String)this.oauth.getRedirectUri()) + "/auth";
        return KeycloakUriBuilder.fromUri((String)authServerBaseUrl).path("/realms/{realm-name}").build(new Object[]{"test"}).toString();
    }

    private ClientAttributeCertificateResource getClientAttributeCertificateResource(String realm, String clientId) {
        return this.getClient(realm, clientId).getCertficateResource("jwt.credential");
    }

    private ClientResource getClient(String realm, String clientId) {
        return this.realmsResouce().realm(realm).clients().get(clientId);
    }

    private static KeyStore getKeystore(InputStream is, String storePassword, String format) throws Exception {
        KeyStore keyStore = format.equals("JKS") ? KeyStore.getInstance(format) : KeyStore.getInstance(format, "BC");
        keyStore.load(is, storePassword.toCharArray());
        return keyStore;
    }

    protected class CustomJWTClientCredentialsProvider
    extends JWTClientCredentialsProvider {
        private Map<String, Boolean> enabledClaims = new HashMap<String, Boolean>();

        public CustomJWTClientCredentialsProvider() {
            String[] claims;
            for (String claim : claims = new String[]{"id", "issuer", "subject", "audience", "expiration", "notBefore", "issuedAt"}) {
                this.enabledClaims.put(claim, true);
            }
        }

        public void enableClaim(String claim, boolean value) {
            if (!this.enabledClaims.containsKey(claim)) {
                throw new IllegalArgumentException("Claim \"" + claim + "\" doesn't exist");
            }
            this.enabledClaims.put(claim, value);
        }

        public boolean isClaimEnabled(String claim) {
            Boolean value = this.enabledClaims.get(claim);
            if (value == null) {
                throw new IllegalArgumentException("Claim \"" + claim + "\" doesn't exist");
            }
            return value;
        }

        public Set<String> getClaims() {
            return this.enabledClaims.keySet();
        }

        protected JsonWebToken createRequestToken(String clientId, String realmInfoUrl) {
            JsonWebToken reqToken = new JsonWebToken();
            if (this.isClaimEnabled("id")) {
                reqToken.id(AdapterUtils.generateId());
            }
            if (this.isClaimEnabled("issuer")) {
                reqToken.issuer(clientId);
            }
            if (this.isClaimEnabled("subject")) {
                reqToken.subject(clientId);
            }
            if (this.isClaimEnabled("audience")) {
                reqToken.audience(new String[]{realmInfoUrl});
            }
            int now = Time.currentTime();
            if (this.isClaimEnabled("issuedAt")) {
                reqToken.issuedAt(now);
            }
            if (this.isClaimEnabled("expiration")) {
                reqToken.expiration(now + this.getTokenTimeout());
            }
            if (this.isClaimEnabled("notBefore")) {
                reqToken.notBefore(now);
            }
            return reqToken;
        }
    }
}

