/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;

public class LoginStatusIframeEndpointTest
extends AbstractKeycloakTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkIframeP3PHeader() throws IOException {
        BasicCookieStore cookieStore = new BasicCookieStore();
        try (CloseableHttpClient client = HttpClients.custom().setDefaultCookieStore((CookieStore)cookieStore).build();){
            String redirectUri = URLEncoder.encode(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/admin/master/console", "UTF-8");
            HttpGet get = new HttpGet(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/protocol/openid-connect/auth?response_type=code&client_id=" + "security-admin-console" + "&redirect_uri=" + redirectUri);
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            String s = IOUtils.toString((InputStream)response.getEntity().getContent());
            response.close();
            Matcher matcher = Pattern.compile("action=\"([^\"]*)\"").matcher(s);
            matcher.find();
            String action = matcher.group(1);
            HttpPost post = new HttpPost(action);
            LinkedList<BasicNameValuePair> params = new LinkedList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("username", "admin"));
            params.add(new BasicNameValuePair("password", "admin"));
            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            response = client.execute((HttpUriRequest)post);
            Assert.assertEquals((Object)"CP=\"This is not a P3P policy!\"", (Object)response.getFirstHeader("P3P").getValue());
            Header setIdentityCookieHeader = null;
            Header setSessionCookieHeader = null;
            for (Header h : response.getAllHeaders()) {
                if (!h.getName().equals("Set-Cookie")) continue;
                if (h.getValue().contains("KEYCLOAK_SESSION")) {
                    setSessionCookieHeader = h;
                    continue;
                }
                if (!h.getValue().contains("KEYCLOAK_IDENTITY")) continue;
                setIdentityCookieHeader = h;
            }
            Assert.assertNotNull(setIdentityCookieHeader);
            Assert.assertTrue((boolean)setIdentityCookieHeader.getValue().contains("HttpOnly"));
            Assert.assertNotNull(setSessionCookieHeader);
            Assert.assertFalse((boolean)setSessionCookieHeader.getValue().contains("HttpOnly"));
            response.close();
            Cookie sessionCookie = null;
            for (Cookie cookie : cookieStore.getCookies()) {
                if (!cookie.getName().equals("KEYCLOAK_SESSION")) continue;
                sessionCookie = cookie;
                break;
            }
            Assert.assertNotNull(sessionCookie);
            get = new HttpGet(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/protocol/openid-connect/login-status-iframe.html?client_id=" + "security-admin-console" + "&origin=" + this.suiteContext.getAuthServerInfo().getContextRoot());
            response = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            s = IOUtils.toString((InputStream)response.getEntity().getContent());
            Assert.assertTrue((boolean)s.contains("function getCookie(cname)"));
            Assert.assertEquals((Object)"CP=\"This is not a P3P policy!\"", (Object)response.getFirstHeader("P3P").getValue());
            response.close();
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }
}

