/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.OAuthClient;

public class OAuthDanceClientSessionExtensionTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realmRepresentation);
    }

    @Test
    public void doOauthDanceWithClientSessionStateAndHost() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        String clientSessionState = "1234";
        String clientSessionHost = "test-client-host";
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.clientSessionState(clientSessionState).clientSessionHost(clientSessionHost).doAccessTokenRequest(code, "password");
        String refreshTokenString = tokenResponse.getRefreshToken();
        EventRepresentation tokenEvent = this.events.expectCodeToToken(codeId, sessionId).detail("client_session_state", clientSessionState).detail("client_session_host", clientSessionHost).assertEvent();
        String updatedClientSessionState = "5678";
        this.oauth.clientSessionState(updatedClientSessionState).clientSessionHost(clientSessionHost).doRefreshTokenRequest(refreshTokenString, "password");
        this.events.expectRefresh((String)tokenEvent.getDetails().get("refresh_token_id"), sessionId).detail("client_session_state", updatedClientSessionState).detail("client_session_host", clientSessionHost).assertEvent();
    }
}

