/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.EventType;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.AccountApplicationsPage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ProtocolMapperUtil;
import org.keycloak.testsuite.util.RoleBuilder;
import org.openqa.selenium.By;

public class OAuthGrantTest
extends AbstractKeycloakTest {
    public static final String THIRD_PARTY_APP = "third-party";
    public static final String REALM_NAME = "test";
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected OAuthGrantPage grantPage;
    @Page
    protected AccountApplicationsPage accountAppsPage;
    @Page
    protected AppPage appPage;
    private static String ROLE_USER = "Have User privileges";
    private static String ROLE_CUSTOMER = "Have Customer User privileges";

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realmRepresentation);
    }

    @Test
    public void oauthGrantAcceptTest() {
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains(ROLE_USER));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains(ROLE_CUSTOMER));
        this.grantPage.accept();
        Assert.assertTrue((boolean)this.oauth.getCurrentQuery().containsKey("code"));
        EventRepresentation loginEvent = this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String sessionId = loginEvent.getSessionId();
        OAuthClient.AccessTokenResponse accessToken = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), "password");
        String tokenString = accessToken.getAccessToken();
        Assert.assertNotNull((Object)tokenString);
        AccessToken token = this.oauth.verifyToken(tokenString);
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        AccessToken.Access realmAccess = token.getRealmAccess();
        Assert.assertEquals((long)1L, (long)realmAccess.getRoles().size());
        Assert.assertTrue((boolean)realmAccess.isUserInRole("user"));
        Map resourceAccess = token.getResourceAccess();
        Assert.assertEquals((long)1L, (long)resourceAccess.size());
        Assert.assertEquals((long)1L, (long)((AccessToken.Access)resourceAccess.get("test-app")).getRoles().size());
        Assert.assertTrue((boolean)((AccessToken.Access)resourceAccess.get("test-app")).isUserInRole("customer-user"));
        this.events.expectCodeToToken(codeId, loginEvent.getSessionId()).client(THIRD_PARTY_APP).assertEvent();
        this.accountAppsPage.open();
        Assert.assertEquals((long)1L, (long)this.driver.findElements(By.id((String)"revoke-third-party")).size());
        this.accountAppsPage.revokeGrant(THIRD_PARTY_APP);
        this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", THIRD_PARTY_APP).assertEvent();
        Assert.assertEquals((long)0L, (long)this.driver.findElements(By.id((String)"revoke-third-party")).size());
    }

    @Test
    public void oauthGrantCancelTest() {
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains(ROLE_USER));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains(ROLE_CUSTOMER));
        this.grantPage.cancel();
        Assert.assertTrue((boolean)this.oauth.getCurrentQuery().containsKey("error"));
        Assert.assertEquals((Object)"access_denied", this.oauth.getCurrentQuery().get("error"));
        this.events.expectLogin().client(THIRD_PARTY_APP).error("rejected_by_user").removeDetail("consent").assertEvent();
    }

    @Test
    public void oauthGrantNotShownWhenAlreadyGranted() {
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        this.grantPage.accept();
        this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        this.accountAppsPage.open();
        AccountApplicationsPage.AppEntry thirdPartyEntry = (AccountApplicationsPage.AppEntry)this.accountAppsPage.getApplications().get(THIRD_PARTY_APP);
        Assert.assertTrue((boolean)thirdPartyEntry.getRolesGranted().contains(ROLE_USER));
        Assert.assertTrue((boolean)thirdPartyEntry.getRolesGranted().contains("Have Customer User privileges in test-app"));
        Assert.assertTrue((boolean)thirdPartyEntry.getProtocolMappersGranted().contains("Full name"));
        Assert.assertTrue((boolean)thirdPartyEntry.getProtocolMappersGranted().contains("Email"));
        this.oauth.openLoginForm();
        this.appPage.assertCurrent();
        this.events.expectLogin().detail("auth_method", "openid-connect").detail("consent", "persistent_consent").removeDetail("username").client(THIRD_PARTY_APP).assertEvent();
        this.accountAppsPage.open();
        this.accountAppsPage.revokeGrant(THIRD_PARTY_APP);
        this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", THIRD_PARTY_APP).assertEvent();
        this.oauth.openLoginForm();
        this.grantPage.assertCurrent();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains(ROLE_USER));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains(ROLE_CUSTOMER));
    }

    @Test
    public void oauthGrantAddAnotherRoleAndMapper() {
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.oauth.scope("grant_type");
        ProtocolMapperRepresentation protocolMapper = ProtocolMapperUtil.createClaimMapper("gss delegation credential", "gss_delegation_credential", "gss_delegation_credential", "String", true, "gss delegation credential", true, false);
        RealmResource appRealm = this.adminClient.realm(REALM_NAME);
        appRealm.roles().create(RoleBuilder.create().name("new-role").build());
        RoleRepresentation newRole = appRealm.roles().get("new-role").toRepresentation();
        ClientManager.realm(this.adminClient.realm(REALM_NAME)).clientId(THIRD_PARTY_APP).addProtocolMapper(protocolMapper).addScopeMapping(newRole);
        UserResource userResource = ApiUtil.findUserByUsernameId(appRealm, "test-user@localhost");
        userResource.roles().realmLevel().add(Collections.singletonList(newRole));
        this.grantPage.assertCurrent();
        this.grantPage.accept();
        this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        this.accountAppsPage.open();
        AccountApplicationsPage.AppEntry appEntry = (AccountApplicationsPage.AppEntry)this.accountAppsPage.getApplications().get(THIRD_PARTY_APP);
        Assert.assertFalse((boolean)appEntry.getRolesGranted().contains("new-role"));
        Assert.assertFalse((boolean)appEntry.getProtocolMappersGranted().contains("gss delegation credential"));
        this.oauth.openLoginForm();
        this.grantPage.assertCurrent();
        Assert.assertFalse((boolean)this.driver.getPageSource().contains(ROLE_USER));
        Assert.assertFalse((boolean)this.driver.getPageSource().contains("Full name"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("new-role"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("gss delegation credential"));
        this.grantPage.accept();
        this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        this.accountAppsPage.open();
        appEntry = (AccountApplicationsPage.AppEntry)this.accountAppsPage.getApplications().get(THIRD_PARTY_APP);
        Assert.assertTrue((boolean)appEntry.getRolesGranted().contains("new-role"));
        Assert.assertTrue((boolean)appEntry.getProtocolMappersGranted().contains("gss delegation credential"));
        this.accountAppsPage.revokeGrant(THIRD_PARTY_APP);
        this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", THIRD_PARTY_APP).assertEvent();
        ClientManager.realm(this.adminClient.realm(REALM_NAME)).clientId(THIRD_PARTY_APP).removeProtocolMapper("gss delegation credential").removeScopeMapping(newRole);
        appRealm.roles().deleteRole("new-role");
    }

    @Test
    public void oauthGrantScopeParamRequired() throws Exception {
        RealmResource appRealm = this.adminClient.realm(REALM_NAME);
        ClientResource thirdParty = ApiUtil.findClientByClientId(appRealm, THIRD_PARTY_APP);
        thirdParty.roles().create(RoleBuilder.create().id("bar-role").name("bar-role").scopeParamRequired(true).build());
        RoleRepresentation barAppRole = thirdParty.roles().get("bar-role").toRepresentation();
        appRealm.roles().create(RoleBuilder.create().id("foo-role").name("foo-role").scopeParamRequired(true).build());
        RoleRepresentation fooRole = appRealm.roles().get("foo-role").toRepresentation();
        ClientManager.realm(appRealm).clientId(THIRD_PARTY_APP).addScopeMapping(fooRole);
        UserResource testUser = ApiUtil.findUserByUsernameId(appRealm, "test-user@localhost");
        testUser.roles().clientLevel(thirdParty.toRepresentation().getId()).add(Collections.singletonList(barAppRole));
        testUser.roles().realmLevel().add(Collections.singletonList(fooRole));
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        Assert.assertFalse((boolean)this.driver.getPageSource().contains("foo-role"));
        Assert.assertFalse((boolean)this.driver.getPageSource().contains("bar-role"));
        this.grantPage.cancel();
        this.events.expectLogin().client(THIRD_PARTY_APP).error("rejected_by_user").removeDetail("consent").assertEvent();
        this.oauth.scope("foo-role third-party/bar-role");
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("foo-role"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("bar-role"));
        this.grantPage.accept();
        this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        this.accountAppsPage.open();
        this.accountAppsPage.revokeGrant(THIRD_PARTY_APP);
        this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", THIRD_PARTY_APP).assertEvent();
        appRealm.roles().deleteRole(fooRole.getName());
        thirdParty.roles().deleteRole(barAppRole.getName());
    }
}

