/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.openqa.selenium.By;

public class OAuthRedirectUriTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected ErrorPage errorPage;
    @Page
    protected LoginPage loginPage;

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).testEventListener();
        ClientBuilder installedApp = ClientBuilder.create().id("test-installed").name("test-installed").redirectUris("urn:ietf:wg:oauth:2.0:oob", "http://localhost").secret("password");
        realm.client(installedApp);
        ClientBuilder installedApp2 = ClientBuilder.create().id("test-installed2").name("test-installed2").redirectUris("http://localhost/myapp").secret("password");
        realm.client(installedApp2);
        ClientBuilder installedApp3 = ClientBuilder.create().id("test-wildcard").name("test-wildcard").redirectUris("http://example.com/foo/*", "http://with-dash.example.com/foo/*", "http://localhost:8180/foo/*").secret("password");
        realm.client(installedApp3);
        ClientBuilder installedApp4 = ClientBuilder.create().id("test-dash").name("test-dash").redirectUris("http://with-dash.example.com", "http://with-dash.example.com/foo").secret("password");
        realm.client(installedApp4);
        ClientBuilder installedApp5 = ClientBuilder.create().id("test-root-url").name("test-root-url").rootUrl("http://with-dash.example.com").redirectUris("/foo").secret("password");
        realm.client(installedApp5);
        ClientBuilder installedApp6 = ClientBuilder.create().id("test-relative-url").name("test-relative-url").rootUrl("").redirectUris("/foo").secret("password");
        realm.client(installedApp6);
        testRealms.add(realm.build());
    }

    @Test
    public void testNoParam() throws IOException {
        this.oauth.redirectUri(null);
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
    }

    @Test
    public void testNoParamMultipleValidUris() throws IOException {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("http://localhost:8180/app2");
        try {
            this.oauth.redirectUri(null);
            this.oauth.openLoginForm();
            Assert.assertTrue((boolean)this.errorPage.isCurrent());
            Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        }
        catch (Throwable throwable) {
            ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").removeRedirectUris("http://localhost:8180/app2");
            throw throwable;
        }
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").removeRedirectUris("http://localhost:8180/app2");
    }

    @Test
    public void testNoParamNoValidUris() throws IOException {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").removeRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
        try {
            this.oauth.redirectUri(null);
            this.oauth.openLoginForm();
            Assert.assertTrue((boolean)this.errorPage.isCurrent());
            Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        }
        catch (Throwable throwable) {
            ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
            throw throwable;
        }
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
    }

    @Test
    public void testNoValidUris() throws IOException {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").removeRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
        try {
            this.oauth.redirectUri(null);
            this.oauth.openLoginForm();
            Assert.assertTrue((boolean)this.errorPage.isCurrent());
            Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        }
        catch (Throwable throwable) {
            ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
            throw throwable;
        }
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
    }

    @Test
    public void testValid() throws IOException {
        this.oauth.redirectUri(OAuthClient.APP_ROOT + "/auth");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response.getCode());
        URL url = new URL(this.driver.getCurrentUrl());
        Assert.assertTrue((boolean)url.toString().startsWith(OAuthClient.APP_ROOT));
        Assert.assertTrue((boolean)url.getQuery().contains("code="));
        Assert.assertTrue((boolean)url.getQuery().contains("state="));
    }

    @Test
    public void testInvalid() throws IOException {
        this.oauth.redirectUri("http://localhost:8180/app2");
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
    }

    @Test
    public void testWithParams() throws IOException {
        this.oauth.redirectUri(OAuthClient.APP_ROOT + "/auth?key=value");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response.getCode());
        URL url = new URL(this.driver.getCurrentUrl());
        Assert.assertTrue((boolean)url.toString().startsWith(OAuthClient.APP_ROOT));
        Assert.assertTrue((boolean)url.getQuery().contains("key=value"));
        Assert.assertTrue((boolean)url.getQuery().contains("state="));
        Assert.assertTrue((boolean)url.getQuery().contains("code="));
    }

    @Test
    public void testWildcard() throws IOException {
        this.oauth.clientId("test-wildcard");
        this.checkRedirectUri("http://example.com", false);
        this.checkRedirectUri("http://localhost:8080", false, true);
        this.checkRedirectUri("http://example.com/foo", true);
        this.checkRedirectUri("http://example.com/foo/bar", true);
        this.checkRedirectUri("http://localhost:8180/foo", true, true);
        this.checkRedirectUri("http://localhost:8180/foo/bar", true, true);
        this.checkRedirectUri("http://example.com/foobar", false);
        this.checkRedirectUri("http://localhost:8180/foobar", false, true);
    }

    @Test
    public void testDash() throws IOException {
        this.oauth.clientId("test-dash");
        this.checkRedirectUri("http://with-dash.example.com/foo", true);
    }

    @Test
    public void testDifferentCaseInHostname() throws IOException {
        this.oauth.clientId("test-dash");
        this.checkRedirectUri("http://with-dash.example.com", true);
        this.checkRedirectUri("http://wiTh-dAsh.example.com", true);
        this.checkRedirectUri("http://with-dash.example.com/foo", true);
        this.checkRedirectUri("http://wiTh-dAsh.example.com/foo", true);
        this.checkRedirectUri("http://with-dash.eXampLe.com/foo", true);
        this.checkRedirectUri("http://wiTh-dAsh.eXampLe.com/foo", true);
        this.checkRedirectUri("http://wiTh-dAsh.eXampLe.com/Foo", false);
        this.checkRedirectUri("http://wiTh-dAsh.eXampLe.com/foO", false);
    }

    @Test
    public void testDifferentCaseInScheme() throws IOException {
        this.oauth.clientId("test-dash");
        this.checkRedirectUri("HTTP://with-dash.example.com", true);
        this.checkRedirectUri("Http://wiTh-dAsh.example.com", true);
    }

    @Test
    public void testRelativeWithRoot() throws IOException {
        this.oauth.clientId("test-root-url");
        this.checkRedirectUri("http://with-dash.example.com/foo", true);
        this.checkRedirectUri("http://localhost:8180/foo", false);
    }

    @Test
    public void testRelative() throws IOException {
        this.oauth.clientId("test-relative-url");
        this.checkRedirectUri("http://with-dash.example.com/foo", false);
        this.checkRedirectUri("http://localhost:8180/foo", true);
    }

    @Test
    public void testLocalhost() throws IOException {
        this.oauth.clientId("test-installed");
        this.checkRedirectUri("urn:ietf:wg:oauth:2.0:oob", true, true);
        this.checkRedirectUri("http://localhost", true);
        this.checkRedirectUri("http://localhost:8280", true, true);
        this.checkRedirectUri("http://localhosts", false);
        this.checkRedirectUri("http://localhost/myapp", false);
        this.checkRedirectUri("http://localhost:8180/myapp", false, true);
        this.oauth.clientId("test-installed2");
        this.checkRedirectUri("http://localhost/myapp", true);
        this.checkRedirectUri("http://localhost:8280/myapp", true, true);
        this.checkRedirectUri("http://localhosts/myapp", false);
        this.checkRedirectUri("http://localhost", false);
        this.checkRedirectUri("http://localhost/myapp2", false);
    }

    private void checkRedirectUri(String redirectUri, boolean expectValid) throws IOException {
        this.checkRedirectUri(redirectUri, expectValid, false);
    }

    private void checkRedirectUri(String redirectUri, boolean expectValid, boolean checkCodeToToken) throws IOException {
        this.oauth.redirectUri(redirectUri);
        this.oauth.openLoginForm();
        if (expectValid) {
            Assert.assertTrue((boolean)this.loginPage.isCurrent());
        } else {
            Assert.assertTrue((boolean)this.errorPage.isCurrent());
            Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        }
        if (expectValid) {
            Assert.assertTrue((boolean)this.loginPage.isCurrent());
            if (checkCodeToToken) {
                this.oauth.doLogin("test-user@localhost", "password");
                if (this.driver.findElements(By.name((String)"login")).size() != 0) {
                    this.driver.findElement(By.name((String)"login")).click();
                }
                String code = (String)this.oauth.getCurrentQuery().get("code");
                Assert.assertNotNull((Object)code);
                OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
                Assert.assertEquals((String)("Expected success, but got error: " + tokenResponse.getError()), (long)200L, (long)tokenResponse.getStatusCode());
                this.oauth.doLogout(tokenResponse.getRefreshToken(), "password");
            }
        }
    }
}

