/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RealmManager;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class OfflineTokenTest
extends AbstractKeycloakTest {
    private static String userId;
    private static String offlineClientAppUri;
    private static String serviceAccountUserId;
    @Page
    protected LoginPage loginPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Before
    public void clientConfiguration() {
        userId = ApiUtil.findUserByUsername(this.adminClient.realm("test"), "test-user@localhost").getId();
        this.oauth.clientId("test-app");
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).accessTokenLifespan(10).ssoSessionIdleTimeout(30).testEventListener();
        offlineClientAppUri = OAuthClient.APP_ROOT + "/offline-client";
        ClientRepresentation app = ClientBuilder.create().clientId("offline-client").id(KeycloakModelUtils.generateId()).adminUrl(offlineClientAppUri).redirectUris(offlineClientAppUri).directAccessGrants().serviceAccountsEnabled(true).secret("secret1").build();
        realm.client(app);
        serviceAccountUserId = KeycloakModelUtils.generateId();
        UserRepresentation serviceAccountUser = UserBuilder.create().id(serviceAccountUserId).addRoles("user", "offline_access").role("test-app", "customer-user").username("service-account-" + app.getClientId()).serviceAccountId(app.getClientId()).build();
        realm.user(serviceAccountUser);
        testRealms.add(realm.build());
    }

    @Test
    public void offlineTokenDisabledForClient() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("offline-client").fullScopeAllowed(false);
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        this.oauth.redirectUri(offlineClientAppUri);
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("offline-client").detail("redirect_uri", offlineClientAppUri).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "secret1");
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        Assert.assertEquals((Object)"not_allowed", (Object)tokenResponse.getError());
        this.events.expectCodeToToken(codeId, sessionId).client("offline-client").error("not_allowed").clearDetails().assertEvent();
        ClientManager.realm(this.adminClient.realm("test")).clientId("offline-client").fullScopeAllowed(true);
    }

    @Test
    public void offlineTokenUserNotAllowed() throws Exception {
        String userId = ApiUtil.findUserByUsername(this.adminClient.realm("test"), "keycloak-user@localhost").getId();
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        this.oauth.redirectUri(offlineClientAppUri);
        this.oauth.doLogin("keycloak-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("offline-client").user(userId).detail("redirect_uri", offlineClientAppUri).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "secret1");
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        Assert.assertEquals((Object)"not_allowed", (Object)tokenResponse.getError());
        this.events.expectCodeToToken(codeId, sessionId).client("offline-client").user(userId).error("not_allowed").clearDetails().assertEvent();
    }

    @Test
    public void offlineTokenBrowserFlow() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        this.oauth.redirectUri(offlineClientAppUri);
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("offline-client").detail("redirect_uri", offlineClientAppUri).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "secret1");
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.verifyRefreshToken(offlineTokenString);
        this.events.expectCodeToToken(codeId, sessionId).client("offline-client").detail("refresh_token_type", "Offline").assertEvent();
        Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
        Assert.assertEquals((long)0L, (long)offlineToken.getExpiration());
        String newRefreshTokenString = this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, sessionId, userId);
        this.setTimeOffset(3000000);
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(newRefreshTokenString, "secret1");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectRefresh(offlineToken.getId(), sessionId).client("offline-client").error("invalid_token").user(userId).clearDetails().assertEvent();
        this.setTimeOffset(0);
    }

    private String testRefreshWithOfflineToken(AccessToken oldToken, RefreshToken offlineToken, String offlineTokenString, String sessionId, String userId) {
        this.setTimeOffset(99999);
        Assert.assertFalse((boolean)oldToken.isActive());
        Assert.assertTrue((boolean)offlineToken.isActive());
        this.testingClient.testing().removeExpired("test");
        this.testingClient.testing().removeUserSession("test", sessionId);
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(offlineTokenString, "secret1");
        AccessToken refreshedToken = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)sessionId, (Object)refreshedToken.getSessionState());
        String newRefreshToken = response.getRefreshToken();
        Assert.assertNotNull((Object)newRefreshToken);
        Assert.assertNotEquals((Object)oldToken.getId(), (Object)refreshedToken.getId());
        Assert.assertEquals((Object)userId, (Object)refreshedToken.getSubject());
        Assert.assertTrue((boolean)refreshedToken.getRealmAccess().isUserInRole("user"));
        Assert.assertTrue((boolean)refreshedToken.getRealmAccess().isUserInRole("offline_access"));
        Assert.assertEquals((long)1L, (long)refreshedToken.getResourceAccess("test-app").getRoles().size());
        Assert.assertTrue((boolean)refreshedToken.getResourceAccess("test-app").isUserInRole("customer-user"));
        EventRepresentation refreshEvent = this.events.expectRefresh(offlineToken.getId(), sessionId).client("offline-client").user(userId).removeDetail("updated_refresh_token_id").detail("refresh_token_type", "Offline").assertEvent();
        Assert.assertNotEquals((Object)oldToken.getId(), refreshEvent.getDetails().get("token_id"));
        this.setTimeOffset(0);
        return newRefreshToken;
    }

    @Test
    public void offlineTokenDirectGrantFlow() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("secret1", "test-user@localhost", "password");
        tokenResponse.getErrorDescription();
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.verifyRefreshToken(offlineTokenString);
        this.events.expectLogin().client("offline-client").user(userId).session(token.getSessionState()).detail("grant_type", "password").detail("token_id", token.getId()).detail("refresh_token_id", offlineToken.getId()).detail("refresh_token_type", "Offline").detail("username", "test-user@localhost").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
        Assert.assertEquals((long)0L, (long)offlineToken.getExpiration());
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), userId);
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), userId);
    }

    @Test
    public void offlineTokenDirectGrantFlowWithRefreshTokensRevoked() throws Exception {
        RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(true);
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("secret1", "test-user@localhost", "password");
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.verifyRefreshToken(offlineTokenString);
        this.events.expectLogin().client("offline-client").user(userId).session(token.getSessionState()).detail("grant_type", "password").detail("token_id", token.getId()).detail("refresh_token_id", offlineToken.getId()).detail("refresh_token_type", "Offline").detail("username", "test-user@localhost").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
        Assert.assertEquals((long)0L, (long)offlineToken.getExpiration());
        String offlineTokenString2 = this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), userId);
        RefreshToken offlineToken2 = this.oauth.verifyRefreshToken(offlineTokenString2);
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(offlineTokenString, "secret1");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        this.events.expectRefresh(offlineToken.getId(), token.getSessionState()).client("offline-client").error("invalid_token").user(userId).clearDetails().assertEvent();
        this.testRefreshWithOfflineToken(token, offlineToken2, offlineTokenString2, token.getSessionState(), userId);
        RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(false);
    }

    @Test
    public void offlineTokenServiceAccountFlow() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.verifyRefreshToken(offlineTokenString);
        this.events.expectClientLogin().client("offline-client").user(serviceAccountUserId).session(token.getSessionState()).detail("token_id", token.getId()).detail("refresh_token_id", offlineToken.getId()).detail("refresh_token_type", "Offline").detail("username", "service-account-offline-client").assertEvent();
        Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
        Assert.assertEquals((long)0L, (long)offlineToken.getExpiration());
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), serviceAccountUserId);
        tokenResponse = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        AccessToken token2 = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString2 = tokenResponse.getRefreshToken();
        RefreshToken offlineToken2 = this.oauth.verifyRefreshToken(offlineTokenString2);
        this.events.expectClientLogin().client("offline-client").user(serviceAccountUserId).session(token2.getSessionState()).detail("token_id", token2.getId()).detail("refresh_token_id", offlineToken2.getId()).detail("refresh_token_type", "Offline").detail("username", "service-account-offline-client").assertEvent();
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), serviceAccountUserId);
        this.testRefreshWithOfflineToken(token2, offlineToken2, offlineTokenString2, token2.getSessionState(), serviceAccountUserId);
    }

    @Test
    public void offlineTokenAllowedWithCompositeRole() throws Exception {
        RealmResource appRealm = this.adminClient.realm("test");
        UserResource testUser = ApiUtil.findUserByUsernameId(appRealm, "test-user@localhost");
        RoleRepresentation offlineAccess = ApiUtil.findRealmRoleByName(this.adminClient.realm("test"), "offline_access").toRepresentation();
        appRealm.roles().create(RoleBuilder.create().name("composite").build());
        RoleResource roleResource = appRealm.roles().get("composite");
        roleResource.addComposites(Collections.singletonList(offlineAccess));
        testUser.roles().realmLevel().remove(Collections.singletonList(offlineAccess));
        testUser.roles().realmLevel().add(Collections.singletonList(roleResource.toRepresentation()));
        this.offlineTokenDirectGrantFlow();
        testUser.roles().realmLevel().remove(Collections.singletonList(appRealm.roles().get("composite").toRepresentation()));
        appRealm.roles().get("composite").remove();
        testUser.roles().realmLevel().add(Collections.singletonList(offlineAccess));
    }
}

