/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RealmManager;
import org.keycloak.util.BasicAuthHelper;

public class RefreshTokenTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    String privateKey;
    String publicKey;

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).testEventListener();
        testRealms.add(realm.build());
    }

    @Test
    public void nullRefreshToken() throws Exception {
        Client client = ClientBuilder.newClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI uri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget target = client.target(uri);
        Object tokenResponse = null;
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        Response response = target.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
        this.events.clear();
    }

    @Test
    public void invalidRefreshToken() throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest("invalid", "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.clear();
    }

    @Test
    public void refreshTokenRequest() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String refreshTokenString = tokenResponse.getRefreshToken();
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(refreshTokenString);
        EventRepresentation tokenEvent = this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        Assert.assertNotNull((Object)refreshTokenString);
        Assert.assertEquals((Object)"bearer", (Object)tokenResponse.getTokenType());
        Assert.assertThat((Object)(token.getExpiration() - this.getCurrentTime()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(200)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(350))));
        int actual = refreshToken.getExpiration() - this.getCurrentTime();
        Assert.assertThat((Object)actual, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1799)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1800))));
        Assert.assertEquals((Object)sessionId, (Object)refreshToken.getSessionState());
        this.setTimeOffset(2);
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(refreshTokenString, "password");
        AccessToken refreshedToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.verifyRefreshToken(response.getRefreshToken());
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)sessionId, (Object)refreshedToken.getSessionState());
        Assert.assertEquals((Object)sessionId, (Object)refreshedRefreshToken.getSessionState());
        Assert.assertThat((Object)response.getExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(250)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(300))));
        Assert.assertThat((Object)(refreshedToken.getExpiration() - this.getCurrentTime()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(250)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(300))));
        Assert.assertThat((Object)(refreshedToken.getExpiration() - token.getExpiration()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
        Assert.assertThat((Object)(refreshedRefreshToken.getExpiration() - refreshToken.getExpiration()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
        Assert.assertNotEquals((Object)token.getId(), (Object)refreshedToken.getId());
        Assert.assertNotEquals((Object)refreshToken.getId(), (Object)refreshedRefreshToken.getId());
        Assert.assertEquals((Object)"bearer", (Object)response.getTokenType());
        Assert.assertEquals((Object)ApiUtil.findUserByUsername(this.adminClient.realm("test"), "test-user@localhost").getId(), (Object)refreshedToken.getSubject());
        Assert.assertNotEquals((Object)"test-user@localhost", (Object)refreshedToken.getSubject());
        Assert.assertEquals((long)1L, (long)refreshedToken.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)refreshedToken.getRealmAccess().isUserInRole("user"));
        Assert.assertEquals((long)1L, (long)refreshedToken.getResourceAccess(this.oauth.getClientId()).getRoles().size());
        Assert.assertTrue((boolean)refreshedToken.getResourceAccess(this.oauth.getClientId()).isUserInRole("customer-user"));
        EventRepresentation refreshEvent = this.events.expectRefresh((String)tokenEvent.getDetails().get("refresh_token_id"), sessionId).assertEvent();
        Assert.assertNotEquals(tokenEvent.getDetails().get("token_id"), refreshEvent.getDetails().get("token_id"));
        Assert.assertNotEquals(tokenEvent.getDetails().get("refresh_token_id"), refreshEvent.getDetails().get("updated_refresh_token_id"));
        this.setTimeOffset(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenReuseTokenWithoutRefreshTokensRevoked() throws Exception {
        try {
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response1 = this.oauth.doAccessTokenRequest(code, "password");
            RefreshToken refreshToken1 = this.oauth.verifyRefreshToken(response1.getRefreshToken());
            this.events.expectCodeToToken(codeId, sessionId).assertEvent();
            this.setTimeOffset(2);
            OAuthClient.AccessTokenResponse response2 = this.oauth.doRefreshTokenRequest(response1.getRefreshToken(), "password");
            Assert.assertEquals((long)200L, (long)response2.getStatusCode());
            this.events.expectRefresh(refreshToken1.getId(), sessionId).assertEvent();
            OAuthClient.AccessTokenResponse response3 = this.oauth.doRefreshTokenRequest(response1.getRefreshToken(), "password");
            Assert.assertEquals((long)200L, (long)response3.getStatusCode());
            this.events.expectRefresh(refreshToken1.getId(), sessionId).assertEvent();
        }
        finally {
            this.setTimeOffset(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenReuseTokenWithRefreshTokensRevoked() throws Exception {
        try {
            RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(true);
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response1 = this.oauth.doAccessTokenRequest(code, "password");
            RefreshToken refreshToken1 = this.oauth.verifyRefreshToken(response1.getRefreshToken());
            this.events.expectCodeToToken(codeId, sessionId).assertEvent();
            this.setTimeOffset(2);
            OAuthClient.AccessTokenResponse response2 = this.oauth.doRefreshTokenRequest(response1.getRefreshToken(), "password");
            RefreshToken refreshToken2 = this.oauth.verifyRefreshToken(response2.getRefreshToken());
            Assert.assertEquals((long)200L, (long)response2.getStatusCode());
            this.events.expectRefresh(refreshToken1.getId(), sessionId).assertEvent();
            OAuthClient.AccessTokenResponse response3 = this.oauth.doRefreshTokenRequest(response1.getRefreshToken(), "password");
            Assert.assertEquals((long)400L, (long)response3.getStatusCode());
            this.events.expectRefresh(refreshToken1.getId(), sessionId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
            this.oauth.doRefreshTokenRequest(response2.getRefreshToken(), "password");
            this.events.expectRefresh(refreshToken2.getId(), sessionId).assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenRealmKeysChanged() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        String refreshTokenString = response.getRefreshToken();
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(refreshTokenString);
        this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        try {
            RealmManager.realm(this.adminClient.realm("test")).generateKeys();
            response = this.oauth.doRefreshTokenRequest(refreshTokenString, "password");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
            this.events.expectRefresh(refreshToken.getId(), sessionId).user((String)null).session((String)null).clearDetails().error("invalid_token").assertEvent();
        }
        finally {
            RealmManager.realm(this.adminClient.realm("test")).keyPair(this.privateKey, this.publicKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenClientDisabled() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        String refreshTokenString = response.getRefreshToken();
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(refreshTokenString);
        this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        try {
            ClientManager.realm(this.adminClient.realm("test")).clientId(this.oauth.getClientId()).enabled(false);
            response = this.oauth.doRefreshTokenRequest(refreshTokenString, "password");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"invalid_client", (Object)response.getError());
            this.events.expectRefresh(refreshToken.getId(), sessionId).user((String)null).session((String)null).clearDetails().error("client_disabled").assertEvent();
        }
        finally {
            ClientManager.realm(this.adminClient.realm("test")).clientId(this.oauth.getClientId()).enabled(true);
        }
    }

    @Test
    public void refreshTokenUserSessionExpired() {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.events.poll();
        String refreshId = this.oauth.verifyRefreshToken(tokenResponse.getRefreshToken()).getId();
        this.testingClient.testing().removeUserSession("test", sessionId);
        tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        Assert.assertNull((Object)tokenResponse.getAccessToken());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        this.events.expectRefresh(refreshId, sessionId).error("invalid_token");
        this.events.clear();
    }

    @Test
    public void testUserSessionRefreshAndIdle() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.events.poll();
        String refreshId = this.oauth.verifyRefreshToken(tokenResponse.getRefreshToken()).getId();
        int last = this.testingClient.testing().getLastSessionRefresh("test", sessionId);
        this.setTimeOffset(2);
        tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
        AccessToken refreshedToken = this.oauth.verifyToken(tokenResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.verifyRefreshToken(tokenResponse.getRefreshToken());
        Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        int next = this.testingClient.testing().getLastSessionRefresh("test", sessionId);
        Assert.assertNotEquals((long)last, (long)next);
        RealmResource realmResource = this.adminClient.realm("test");
        int lastAccessTokenLifespan = realmResource.toRepresentation().getAccessTokenLifespan();
        RealmManager.realm(realmResource).accessTokenLifespan(100000);
        this.setTimeOffset(4);
        tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
        next = this.testingClient.testing().getLastSessionRefresh("test", sessionId);
        Assert.assertThat((Object)next, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(last)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(last + 50))));
        int originalIdle = realmResource.toRepresentation().getSsoSessionIdleTimeout();
        RealmManager.realm(realmResource).ssoSessionIdleTimeout(1);
        this.events.clear();
        this.setTimeOffset(6);
        tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        Assert.assertNull((Object)tokenResponse.getAccessToken());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        this.events.expectRefresh(refreshId, sessionId).error("invalid_token");
        RealmManager.realm(realmResource).ssoSessionIdleTimeout(originalIdle).accessTokenLifespan(lastAccessTokenLifespan);
        this.events.clear();
        this.setTimeOffset(0);
    }

    @Test
    public void refreshTokenUserSessionMaxLifespan() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.events.poll();
        String refreshId = this.oauth.verifyRefreshToken(tokenResponse.getRefreshToken()).getId();
        RealmResource realmResource = this.adminClient.realm("test");
        Integer maxLifespan = realmResource.toRepresentation().getSsoSessionMaxLifespan();
        RealmManager.realm(realmResource).ssoSessionMaxLifespan(1);
        this.setTimeOffset(1);
        tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        Assert.assertNull((Object)tokenResponse.getAccessToken());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        RealmManager.realm(realmResource).ssoSessionMaxLifespan(maxLifespan);
        this.events.expectRefresh(refreshId, sessionId).error("invalid_token");
        this.events.clear();
        this.setTimeOffset(0);
    }

    @Test
    public void testCheckSsl() throws Exception {
        Client client = ClientBuilder.newClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget grantTarget = client.target(grantUri);
        builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI uri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget refreshTarget = client.target(uri);
        String refreshToken = null;
        Response response = this.executeGrantAccessTokenRequest(grantTarget);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        refreshToken = tokenResponse.getRefreshToken();
        response.close();
        response = this.executeRefreshToken(refreshTarget, refreshToken);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        refreshToken = tokenResponse.getRefreshToken();
        response.close();
        RealmResource realmResource = this.adminClient.realm("test");
        RealmManager.realm(realmResource).sslRequired(SslRequired.ALL.toString());
        Response response2 = this.executeRefreshToken(refreshTarget, refreshToken);
        Assert.assertEquals((long)403L, (long)response2.getStatus());
        response2.close();
        RealmManager.realm(realmResource).sslRequired(SslRequired.EXTERNAL.toString());
        response = this.executeRefreshToken(refreshTarget, refreshToken);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        refreshToken = tokenResponse.getRefreshToken();
        response.close();
        client.close();
        this.events.clear();
    }

    protected Response executeRefreshToken(WebTarget refreshTarget, String refreshToken) {
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        form.param("grant_type", "refresh_token");
        form.param("refresh_token", refreshToken);
        return refreshTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
    }

    protected Response executeGrantAccessTokenRequest(WebTarget grantTarget) {
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        form.param("grant_type", "password").param("username", "test-user@localhost").param("password", "password");
        return grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
    }
}

