/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RealmManager;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.UserManager;

public class ResourceOwnerPasswordCredentialsGrantTest
extends AbstractKeycloakTest {
    private static String userId;
    private static String userId2;
    private TimeBasedOTP totp = new TimeBasedOTP();
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder realm = RealmBuilder.create().name("test").privateKey("MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=").publicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB").testEventListener();
        ClientRepresentation app = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("resource-owner").directAccessGrants().secret("secret").build();
        realm.client(app);
        ClientRepresentation app2 = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("resource-owner-public").directAccessGrants().publicClient().build();
        realm.client(app2);
        UserBuilder defaultUser = UserBuilder.create().id(KeycloakModelUtils.generateId()).username("test-user@localhost").password("password");
        realm.user(defaultUser);
        userId = KeycloakModelUtils.generateId();
        UserRepresentation user = UserBuilder.create().id(userId).username("direct-login").email("direct-login@localhost").password("password").build();
        realm.user(user);
        userId2 = KeycloakModelUtils.generateId();
        UserRepresentation user2 = UserBuilder.create().id(userId2).username("direct-login-otp").password("password").totpSecret("totpSecret").build();
        realm.user(user2);
        testRealms.add(realm.build());
    }

    @Test
    public void grantAccessTokenUsername() throws Exception {
        this.grantAccessToken("direct-login", "resource-owner");
    }

    @Test
    public void grantAccessTokenEmail() throws Exception {
        this.grantAccessToken("direct-login@localhost", "resource-owner");
    }

    @Test
    public void grantAccessTokenPublic() throws Exception {
        this.grantAccessToken("direct-login", "resource-owner-public");
    }

    @Test
    public void grantAccessTokenWithTotp() throws Exception {
        this.grantAccessToken(userId2, "direct-login-otp", "resource-owner", this.totp.generateTOTP("totpSecret"));
    }

    @Test
    public void grantAccessTokenMissingTotp() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "direct-login-otp", "password");
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("invalid_user_credentials").user(userId2).assertEvent();
    }

    @Test
    public void grantAccessTokenInvalidTotp() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "direct-login-otp", "password", this.totp.generateTOTP("totpSecret2"));
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("invalid_user_credentials").user(userId2).assertEvent();
    }

    private void grantAccessToken(String login, String clientId) throws Exception {
        this.grantAccessToken(userId, login, clientId, null);
    }

    private void grantAccessToken(String userId, String login, String clientId, String otp) throws Exception {
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", login, "password", otp);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(response.getRefreshToken());
        this.events.expectLogin().client(clientId).user(userId).session(accessToken.getSessionState()).detail("grant_type", "password").detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", login).removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshToken.getSessionState());
        OAuthClient.AccessTokenResponse refreshedResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret");
        AccessToken refreshedAccessToken = this.oauth.verifyToken(refreshedResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.verifyRefreshToken(refreshedResponse.getRefreshToken());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedAccessToken.getSessionState());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedRefreshToken.getSessionState());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).user(userId).client(clientId).assertEvent();
    }

    @Test
    public void grantAccessTokenLogout() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(response.getRefreshToken());
        this.events.expectLogin().client("resource-owner").session(accessToken.getSessionState()).detail("grant_type", "password").detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").detail("client_auth_method", "client-secret").assertEvent();
        HttpResponse logoutResponse = this.oauth.doLogout(response.getRefreshToken(), "secret");
        Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
        this.events.expectLogout(accessToken.getSessionState()).client("resource-owner").removeDetail("redirect_uri").assertEvent();
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).client("resource-owner").removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
    }

    @Test
    public void grantAccessTokenInvalidClientCredentials() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("invalid", "test-user@localhost", "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("invalid_client_credentials").user((String)null).assertEvent();
    }

    @Test
    public void grantAccessTokenMissingClientCredentials() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest(null, "test-user@localhost", "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("invalid_client_credentials").user((String)null).assertEvent();
    }

    @Test
    public void grantAccessTokenClientNotAllowed() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("resource-owner").directAccessGrant(false);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("not_allowed").user((String)null).assertEvent();
        ClientManager.realm(this.adminClient.realm("test")).clientId("resource-owner").directAccessGrant(true);
    }

    @Test
    public void grantAccessTokenVerifyEmail() throws Exception {
        RealmResource realmResource = this.adminClient.realm("test");
        RealmManager.realm(realmResource).verifyEmail(true);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"Account is not fully set up", (Object)response.getErrorDescription());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("resolve_required_actions").user((String)null).assertEvent();
        RealmManager.realm(realmResource).verifyEmail(false);
        UserManager.realm(realmResource).username("test-user@localhost").removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL.toString());
    }

    @Test
    public void grantAccessTokenExpiredPassword() throws Exception {
        RealmResource realmResource = this.adminClient.realm("test");
        RealmManager.realm(realmResource).passwordPolicy("forceExpiredPasswordChange(1)");
        try {
            this.setTimeOffset(172800);
            this.oauth.clientId("resource-owner");
            OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "password");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
            Assert.assertEquals((Object)"Account is not fully set up", (Object)response.getErrorDescription());
            this.setTimeOffset(0);
            this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("resolve_required_actions").user((String)null).assertEvent();
        }
        finally {
            RealmManager.realm(realmResource).passwordPolicy("");
            UserManager.realm(realmResource).username("test-user@localhost").removeRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        }
    }

    @Test
    public void grantAccessTokenInvalidUserCredentials() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "invalid");
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").session((String)null).detail("grant_type", "password").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").error("invalid_user_credentials").assertEvent();
    }

    @Test
    public void grantAccessTokenUserNotFound() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "invalid", "invalid");
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").user((String)null).session((String)null).detail("grant_type", "password").detail("username", "invalid").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").error("invalid_user_credentials").assertEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void grantAccessTokenMissingGrantType() throws Exception {
        this.oauth.clientId("resource-owner");
        try (DefaultHttpClient client = new DefaultHttpClient();){
            HttpPost post = new HttpPost(this.oauth.getResourceOwnerPasswordCredentialGrantUrl());
            OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse((HttpResponse)client.execute((HttpUriRequest)post));
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
            Assert.assertEquals((Object)"Missing form parameter: grant_type", (Object)response.getErrorDescription());
        }
    }
}

