/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.List;
import org.apache.http.HttpResponse;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class ServiceAccountTest
extends AbstractKeycloakTest {
    private static String userId;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder realm = RealmBuilder.create().name("test").privateKey("MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=").publicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB").testEventListener();
        ClientRepresentation enabledApp = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("service-account-cl").secret("secret1").serviceAccountsEnabled(true).build();
        realm.client(enabledApp);
        ClientRepresentation disabledApp = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("service-account-disabled").secret("secret1").build();
        realm.client(disabledApp);
        UserBuilder defaultUser = UserBuilder.create().id(KeycloakModelUtils.generateId()).username("test-user@localhost");
        realm.user(defaultUser);
        userId = KeycloakModelUtils.generateId();
        UserBuilder serviceAccountUser = UserBuilder.create().id(userId).username("service-account-" + enabledApp.getClientId()).serviceAccountId(enabledApp.getClientId());
        realm.user(serviceAccountUser);
        testRealms.add(realm.build());
    }

    @Test
    public void clientCredentialsAuthSuccess() throws Exception {
        this.oauth.clientId("service-account-cl");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(response.getRefreshToken());
        this.events.expectClientLogin().client("service-account-cl").user(userId).session(accessToken.getSessionState()).detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", "service-account-service-account-cl").assertEvent();
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshToken.getSessionState());
        System.out.println("Access token other claims: " + accessToken.getOtherClaims());
        Assert.assertEquals((Object)"service-account-cl", accessToken.getOtherClaims().get("clientId"));
        Assert.assertTrue((boolean)accessToken.getOtherClaims().containsKey("clientAddress"));
        Assert.assertTrue((boolean)accessToken.getOtherClaims().containsKey("clientHost"));
        OAuthClient.AccessTokenResponse refreshedResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret1");
        AccessToken refreshedAccessToken = this.oauth.verifyToken(refreshedResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.verifyRefreshToken(refreshedResponse.getRefreshToken());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedAccessToken.getSessionState());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedRefreshToken.getSessionState());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).user(userId).client("service-account-cl").assertEvent();
    }

    @Test
    public void clientCredentialsLogout() throws Exception {
        this.oauth.clientId("service-account-cl");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(response.getRefreshToken());
        this.events.expectClientLogin().client("service-account-cl").user(userId).session(accessToken.getSessionState()).detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", "service-account-service-account-cl").detail("client_auth_method", "client-secret").assertEvent();
        HttpResponse logoutResponse = this.oauth.doLogout(response.getRefreshToken(), "secret1");
        Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
        this.events.expectLogout(accessToken.getSessionState()).client("service-account-cl").user(userId).removeDetail("redirect_uri").assertEvent();
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret1");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).client("service-account-cl").user(userId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
    }

    @Test
    public void clientCredentialsInvalidClientCredentials() throws Exception {
        this.oauth.clientId("service-account-cl");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret2");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        this.events.expectClientLogin().client("service-account-cl").session((String)null).clearDetails().error("invalid_client_credentials").user((String)null).assertEvent();
    }

    @Test
    public void clientCredentialsDisabledServiceAccount() throws Exception {
        this.oauth.clientId("service-account-disabled");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        this.events.expectClientLogin().client("service-account-disabled").user((String)null).session((String)null).removeDetail("username").removeDetail("response_type").error("invalid_client").assertEvent();
    }

    @Test
    public void changeClientIdTest() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("service-account-cl").renameTo("updated-client");
        this.oauth.clientId("updated-client");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.verifyRefreshToken(response.getRefreshToken());
        Assert.assertEquals((Object)"updated-client", accessToken.getOtherClaims().get("clientId"));
        this.events.expectClientLogin().client("updated-client").user(userId).session(accessToken.getSessionState()).detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", "service-account-service-account-cl").assertEvent();
        ClientManager.realm(this.adminClient.realm("test")).clientId("updated-client").renameTo("service-account-cl");
    }
}

