/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.oidc.TokenMetadataRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.util.KeycloakModelUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.util.JsonSerialization;

public class TokenIntrospectionTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        ClientRepresentation confApp = KeycloakModelUtils.createClient(testRealm, "confidential-cli");
        confApp.setSecret("secret1");
        confApp.setServiceAccountsEnabled(Boolean.TRUE);
        ClientRepresentation pubApp = KeycloakModelUtils.createClient(testRealm, "public-cli");
        pubApp.setPublicClient(Boolean.TRUE);
        UserRepresentation user = new UserRepresentation();
        user.setUsername("no-permissions");
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue("password");
        ArrayList<CredentialRepresentation> creds = new ArrayList<CredentialRepresentation>();
        creds.add(credential);
        user.setCredentials(creds);
        user.setEnabled(Boolean.TRUE);
        ArrayList<String> realmRoles = new ArrayList<String>();
        realmRoles.add("user");
        user.setRealmRoles(realmRoles);
        testRealm.getUsers().add(user);
    }

    @Test
    public void testConfidentialClientCredentialsBasicAuthentication() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(tokenResponse);
        Assert.assertTrue((boolean)jsonNode.get("active").asBoolean());
        Assert.assertEquals((Object)"test-user@localhost", (Object)jsonNode.get("username").asText());
        Assert.assertEquals((Object)"test-app", (Object)jsonNode.get("client_id").asText());
        Assert.assertTrue((boolean)jsonNode.has("exp"));
        Assert.assertTrue((boolean)jsonNode.has("iat"));
        Assert.assertTrue((boolean)jsonNode.has("nbf"));
        Assert.assertTrue((boolean)jsonNode.has("sub"));
        Assert.assertTrue((boolean)jsonNode.has("aud"));
        Assert.assertTrue((boolean)jsonNode.has("iss"));
        Assert.assertTrue((boolean)jsonNode.has("jti"));
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)objectMapper.readValue(tokenResponse, TokenMetadataRepresentation.class);
        Assert.assertTrue((boolean)rep.isActive());
        Assert.assertEquals((Object)"test-user@localhost", (Object)rep.getUserName());
        Assert.assertEquals((Object)"test-app", (Object)rep.getClientId());
        Assert.assertEquals((long)jsonNode.get("exp").asInt(), (long)rep.getExpiration());
        Assert.assertEquals((long)jsonNode.get("iat").asInt(), (long)rep.getIssuedAt());
        Assert.assertEquals((long)jsonNode.get("nbf").asInt(), (long)rep.getNotBefore());
        Assert.assertEquals((Object)jsonNode.get("sub").asText(), (Object)rep.getSubject());
        Assert.assertEquals((Object)jsonNode.get("aud").asText(), (Object)rep.getAudience()[0]);
        Assert.assertEquals((Object)jsonNode.get("iss").asText(), (Object)rep.getIssuer());
        Assert.assertEquals((Object)jsonNode.get("jti").asText(), (Object)rep.getId());
    }

    @Test
    public void testInvalidClientCredentials() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "bad_credential", accessTokenResponse.getAccessToken());
        Assert.assertEquals((Object)"{\"error_description\":\"Authentication failed.\",\"error\":\"invalid_request\"}", (Object)tokenResponse);
    }

    @Test
    public void testIntrospectRefreshToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String tokenResponse = this.oauth.introspectRefreshTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(tokenResponse);
        Assert.assertTrue((boolean)jsonNode.get("active").asBoolean());
        Assert.assertEquals((Object)sessionId, (Object)jsonNode.get("session_state").asText());
        Assert.assertEquals((Object)"test-app", (Object)jsonNode.get("client_id").asText());
        Assert.assertTrue((boolean)jsonNode.has("exp"));
        Assert.assertTrue((boolean)jsonNode.has("iat"));
        Assert.assertTrue((boolean)jsonNode.has("nbf"));
        Assert.assertTrue((boolean)jsonNode.has("sub"));
        Assert.assertTrue((boolean)jsonNode.has("aud"));
        Assert.assertTrue((boolean)jsonNode.has("iss"));
        Assert.assertTrue((boolean)jsonNode.has("jti"));
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)objectMapper.readValue(tokenResponse, TokenMetadataRepresentation.class);
        Assert.assertTrue((boolean)rep.isActive());
        Assert.assertEquals((Object)"test-app", (Object)rep.getClientId());
        Assert.assertEquals((Object)jsonNode.get("session_state").asText(), (Object)rep.getSessionState());
        Assert.assertEquals((long)jsonNode.get("exp").asInt(), (long)rep.getExpiration());
        Assert.assertEquals((long)jsonNode.get("iat").asInt(), (long)rep.getIssuedAt());
        Assert.assertEquals((long)jsonNode.get("nbf").asInt(), (long)rep.getNotBefore());
        Assert.assertEquals((Object)jsonNode.get("iss").asText(), (Object)rep.getIssuer());
        Assert.assertEquals((Object)jsonNode.get("jti").asText(), (Object)rep.getId());
    }

    @Test
    public void testPublicClientCredentialsNotAllowed() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("public-cli", "it_doesnt_matter", accessTokenResponse.getAccessToken());
        Assert.assertEquals((Object)"{\"error_description\":\"Client not allowed.\",\"error\":\"invalid_request\"}", (Object)tokenResponse);
    }

    @Test
    public void testInactiveAccessToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String inactiveAccessToken = "eyJhbGciOiJSUzI1NiJ9.eyJub25jZSI6IjczMGZjNjQ1LTBlMDQtNDE3Yi04MDY0LTkyYWIyY2RjM2QwZSIsImp0aSI6ImU5ZGU1NjU2LWUzMjctNDkxNC1hNjBmLTI1MzJlYjBiNDk4OCIsImV4cCI6MTQ1MjI4MTAwMCwibmJmIjowLCJpYXQiOjE0NTIyODA3MDAsImlzcyI6Imh0dHA6Ly9sb2NhbGhvc3Q6ODA4MC9hdXRoL3JlYWxtcy9leGFtcGxlIiwiYXVkIjoianMtY29uc29sZSIsInN1YiI6IjFkNzQ0MDY5LWYyOTgtNGU3Yy1hNzNiLTU1YzlhZjgzYTY4NyIsInR5cCI6IkJlYXJlciIsImF6cCI6ImpzLWNvbnNvbGUiLCJzZXNzaW9uX3N0YXRlIjoiNzc2YTA0OTktODNjNC00MDhkLWE5YjctYTZiYzQ5YmQ3MThjIiwiY2xpZW50X3Nlc3Npb24iOiJjN2Y5ODczOC05MDhlLTQxOWYtYTdkNC1kODYxYjRhYTI3NjkiLCJhbGxvd2VkLW9yaWdpbnMiOltdLCJyZWFsbV9hY2Nlc3MiOnsicm9sZXMiOlsidXNlciJdfSwicmVzb3VyY2VfYWNjZXNzIjp7ImFjY291bnQiOnsicm9sZXMiOlsibWFuYWdlLWFjY291bnQiLCJ2aWV3LXByb2ZpbGUiXX19LCJuYW1lIjoiU2FtcGxlIFVzZXIiLCJwcmVmZXJyZWRfdXNlcm5hbWUiOiJ1c2VyIiwiZ2l2ZW5fbmFtZSI6IlNhbXBsZSIsImZhbWlseV9uYW1lIjoiVXNlciIsImVtYWlsIjoic2FtcGxlLXVzZXJAZXhhbXBsZSJ9.YyPV74j9CqOG2Jmq692ZZpqycjNpUgtYVRfQJccS_FU84tGVXoKKsXKYeY2UJ1Y_bPiYG1I1J6JSXC8XqgQijCG7Nh7oK0yN74JbRN58HG75fvg6K9BjR6hgJ8mHT8qPrCux2svFucIMIZ180eoBoRvRstkidOhl_mtjT_i31fU";
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", inactiveAccessToken);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(tokenResponse);
        Assert.assertFalse((boolean)jsonNode.get("active").asBoolean());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)objectMapper.readValue(tokenResponse, TokenMetadataRepresentation.class);
        Assert.assertFalse((boolean)rep.isActive());
        Assert.assertNull((Object)rep.getUserName());
        Assert.assertNull((Object)rep.getClientId());
        Assert.assertNull((Object)rep.getSubject());
    }

    @Test
    public void testIntrospectAccessToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        Assert.assertTrue((boolean)rep.isActive());
        Assert.assertEquals((Object)"test-user@localhost", (Object)rep.getUserName());
        Assert.assertEquals((Object)"test-app", (Object)rep.getClientId());
        Assert.assertEquals((Object)loginEvent.getUserId(), (Object)rep.getSubject());
    }

    @Test
    public void testIntrospectAccessTokenSessionInvalid() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.oauth.doLogout(accessTokenResponse.getRefreshToken(), "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        Assert.assertFalse((boolean)rep.isActive());
        Assert.assertNull((Object)rep.getUserName());
        Assert.assertNull((Object)rep.getClientId());
        Assert.assertNull((Object)rep.getSubject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIntrospectAccessTokenUserDisabled() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        UserRepresentation userRep = new UserRepresentation();
        try {
            userRep.setEnabled(Boolean.valueOf(false));
            this.adminClient.realm(this.oauth.getRealm()).users().get(loginEvent.getUserId()).update(userRep);
            String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
            TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
            Assert.assertFalse((boolean)rep.isActive());
            Assert.assertNull((Object)rep.getUserName());
            Assert.assertNull((Object)rep.getClientId());
            Assert.assertNull((Object)rep.getSubject());
        }
        finally {
            userRep.setEnabled(Boolean.valueOf(true));
            this.adminClient.realm(this.oauth.getRealm()).users().get(loginEvent.getUserId()).update(userRep);
        }
    }

    @Test
    public void testIntrospectAccessTokenExpired() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.setTimeOffset(this.adminClient.realm(this.oauth.getRealm()).toRepresentation().getAccessTokenLifespan() + 1);
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        Assert.assertFalse((boolean)rep.isActive());
        Assert.assertNull((Object)rep.getUserName());
        Assert.assertNull((Object)rep.getClientId());
        Assert.assertNull((Object)rep.getSubject());
    }
}

