/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.util.Time;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;

public class OIDCAdvancedRequestParamsTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected OAuthGrantPage grantPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
        this.oauth.clientId("test-app");
        this.oauth.maxAge(null);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void testMaxAge1() {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTime = idToken.getAuthTime();
        int currentTime = Time.currentTime();
        Assert.assertTrue((authTime <= currentTime && authTime + 3 >= currentTime ? 1 : 0) != 0);
        this.setTimeOffset(10);
        this.oauth.maxAge("1");
        this.oauth.doLogin("test-user@localhost", "password");
        loginEvent = this.events.expectLogin().assertEvent();
        idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTimeUpdated = idToken.getAuthTime();
        Assert.assertTrue((authTime + 10 <= authTimeUpdated ? 1 : 0) != 0);
    }

    @Test
    public void testMaxAge10000() {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTime = idToken.getAuthTime();
        int currentTime = Time.currentTime();
        Assert.assertTrue((authTime <= currentTime && authTime + 3 >= currentTime ? 1 : 0) != 0);
        this.setTimeOffset(10);
        this.oauth.maxAge("10000");
        this.oauth.openLoginForm();
        loginEvent = this.events.expectLogin().assertEvent();
        idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTimeUpdated = idToken.getAuthTime();
        Assert.assertEquals((long)authTime, (long)authTimeUpdated);
    }

    @Test
    public void promptNoneNotLogged() {
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&prompt=none");
        org.junit.Assert.assertFalse((boolean)this.loginPage.isCurrent());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        this.events.assertEmpty();
        OAuthClient.AuthorizationEndpointResponse resp = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertNull((Object)resp.getCode());
        Assert.assertEquals((Object)"login_required", (Object)resp.getError());
    }

    @Test
    public void promptNoneSuccess() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTime = idToken.getAuthTime();
        this.setTimeOffset(10);
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&prompt=none");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        loginEvent = this.events.expectLogin().removeDetail("username").assertEvent();
        idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTime2 = idToken.getAuthTime();
        Assert.assertEquals((long)authTime, (long)authTime2);
    }

    @Test
    public void promptNoneConsentRequired() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").consentRequired(true);
        try {
            this.profilePage.open();
            org.junit.Assert.assertTrue((boolean)this.loginPage.isCurrent());
            this.loginPage.login("test-user@localhost", "password");
            this.profilePage.assertCurrent();
            this.events.expectLogin().client("account").removeDetail("redirect_uri").detail("username", "test-user@localhost").assertEvent();
            this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&prompt=none");
            org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            OAuthClient.AuthorizationEndpointResponse resp = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
            Assert.assertNull((Object)resp.getCode());
            Assert.assertEquals((Object)"interaction_required", (Object)resp.getError());
            this.driver.navigate().to(this.oauth.getLoginFormUrl());
            this.grantPage.assertCurrent();
            this.grantPage.accept();
            this.events.expectLogin().detail("username", "test-user@localhost").detail("consent", "consent_granted").assertEvent();
            this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&prompt=none");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            resp = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
            Assert.assertNotNull((Object)resp.getCode());
            Assert.assertNull((Object)resp.getError());
            this.events.expectLogin().detail("username", "test-user@localhost").detail("consent", "persistent_consent").assertEvent();
        }
        finally {
            ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").consentRequired(false);
        }
    }

    @Test
    public void promptLogin() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTime = idToken.getAuthTime();
        this.setTimeOffset(10);
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&prompt=login");
        this.loginPage.assertCurrent();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTimeUpdated = idToken.getAuthTime();
        Assert.assertTrue((authTime + 10 <= authTimeUpdated ? 1 : 0) != 0);
    }

    @Test
    public void nonSupportedParams() {
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&display=popup&foo=foobar&claims_locales=fr");
        this.loginPage.assertCurrent();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        Assert.assertNotNull((Object)idToken);
    }

    @Test
    public void requestParam() {
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&request=abc");
        org.junit.Assert.assertFalse((boolean)this.loginPage.isCurrent());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        OAuthClient.AuthorizationEndpointResponse resp = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertNull((Object)resp.getCode());
        Assert.assertEquals((Object)"request_not_supported", (Object)resp.getError());
    }

    @Test
    public void requestUriParam() {
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&request_uri=https%3A%2F%2Flocalhost%3A60784%2Fexport%2FqzHTG11W48.jwt");
        org.junit.Assert.assertFalse((boolean)this.loginPage.isCurrent());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        OAuthClient.AuthorizationEndpointResponse resp = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertNull((Object)resp.getCode());
        Assert.assertEquals((Object)"request_uri_not_supported", (Object)resp.getError());
    }

    @Test
    public void loginHint() {
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&" + "login_hint" + "=test-user%40localhost");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.loginPage.getUsername());
        this.loginPage.login("password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
    }
}

