/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;

public class OIDCWellKnownProviderTest
extends AbstractKeycloakTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
        this.oauth.clientId("test-app");
    }

    @Test
    public void testDiscovery() {
        try (Client client = ClientBuilder.newClient();){
            OIDCConfigurationRepresentation oidcConfig = this.getOIDCDiscoveryConfiguration(client);
            Assert.assertEquals((Object)oidcConfig.getAuthorizationEndpoint(), (Object)OIDCLoginProtocolService.authUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT)).build(new Object[]{"test"}).toString());
            Assert.assertEquals((Object)oidcConfig.getTokenEndpoint(), (Object)this.oauth.getAccessTokenUrl());
            Assert.assertEquals((Object)oidcConfig.getUserinfoEndpoint(), (Object)OIDCLoginProtocolService.userInfoUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT)).build(new Object[]{"test"}).toString());
            Assert.assertEquals((Object)oidcConfig.getJwksUri(), (Object)this.oauth.getCertsUrl("test"));
            this.assertContains(oidcConfig.getResponseTypesSupported(), "code", "id_token", "id_token token", "code id_token", "code token", "code id_token token");
            this.assertContains(oidcConfig.getGrantTypesSupported(), "authorization_code", "implicit");
            this.assertContains(oidcConfig.getResponseModesSupported(), "query", "fragment");
            Assert.assertNames(oidcConfig.getSubjectTypesSupported(), "public");
            Assert.assertNames(oidcConfig.getIdTokenSigningAlgValuesSupported(), Algorithm.RS256.toString());
            Assert.assertNames(oidcConfig.getTokenEndpointAuthMethodsSupported(), "client_secret_basic", "client_secret_post", "private_key_jwt");
            Assert.assertNames(oidcConfig.getTokenEndpointAuthSigningAlgValuesSupported(), Algorithm.RS256.toString());
            this.assertContains(oidcConfig.getClaimsSupported(), "name", "email", "preferred_username", "family_name");
            Assert.assertNames(oidcConfig.getClaimTypesSupported(), "normal");
            Assert.assertFalse((boolean)oidcConfig.getClaimsParameterSupported());
            Assert.assertNames(oidcConfig.getScopesSupported(), "openid", "offline_access");
            Assert.assertFalse((boolean)oidcConfig.getRequestParameterSupported());
            Assert.assertFalse((boolean)oidcConfig.getRequestUriParameterSupported());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIssuerMatches() throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        try (Client client = ClientBuilder.newClient();){
            OIDCConfigurationRepresentation oidcConfig = this.getOIDCDiscoveryConfiguration(client);
            Assert.assertEquals((Object)idToken.getIssuer(), (Object)oidcConfig.getIssuer());
        }
    }

    private OIDCConfigurationRepresentation getOIDCDiscoveryConfiguration(Client client) {
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI oidcDiscoveryUri = RealmsResource.wellKnownProviderUrl((UriBuilder)builder).build(new Object[]{"test", "openid-configuration"});
        WebTarget oidcDiscoveryTarget = client.target(oidcDiscoveryUri);
        Response response = oidcDiscoveryTarget.request().get();
        return (OIDCConfigurationRepresentation)response.readEntity(OIDCConfigurationRepresentation.class);
    }

    private void assertContains(List<String> actual, String ... expected) {
        for (String exp : expected) {
            Assert.assertTrue((boolean)actual.contains(exp));
        }
    }
}

