/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserInfoClientUtil;
import org.keycloak.util.BasicAuthHelper;

public class UserInfoTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).testEventListener();
        testRealms.add(realm.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccess_getMethod_header() throws Exception {
        try (Client client = ClientBuilder.newClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest(client);
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getToken());
            this.testSuccessfulUserInfoResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccess_postMethod_header() throws Exception {
        try (Client client = ClientBuilder.newClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest(client);
            WebTarget userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget((Client)client);
            Response response = userInfoTarget.request().header("Authorization", (Object)("bearer " + accessTokenResponse.getToken())).post(Entity.form((Form)new Form()));
            this.testSuccessfulUserInfoResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccess_postMethod_body() throws Exception {
        try (Client client = ClientBuilder.newClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest(client);
            Form form = new Form();
            form.param("access_token", accessTokenResponse.getToken());
            WebTarget userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget((Client)client);
            Response response = userInfoTarget.request().post(Entity.form((Form)form));
            this.testSuccessfulUserInfoResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccess_postMethod_header_textEntity() throws Exception {
        try (Client client = ClientBuilder.newClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest(client);
            WebTarget userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget((Client)client);
            Response response = userInfoTarget.request().header("Authorization", (Object)("bearer " + accessTokenResponse.getToken())).post(Entity.text((Object)""));
            this.testSuccessfulUserInfoResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionExpired() throws Exception {
        try (Client client = ClientBuilder.newClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest(client);
            this.testingClient.testing().removeUserSessions("test");
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getToken());
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
            response.close();
            this.events.expect(EventType.USER_INFO_REQUEST_ERROR).error("user_session_not_found").client((String)null).user((Matcher<String>)Matchers.nullValue(String.class)).session((Matcher<String>)Matchers.nullValue(String.class)).detail("auth_method", "validate_access_token").assertEvent();
        }
    }

    @Test
    public void testUnsuccessfulUserInfoRequest() throws Exception {
        try (Client client = ClientBuilder.newClient();){
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)"bad");
            response.close();
            Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
            this.events.expect(EventType.USER_INFO_REQUEST_ERROR).error("invalid_token").client((String)null).user((Matcher<String>)Matchers.nullValue(String.class)).session((Matcher<String>)Matchers.nullValue(String.class)).detail("auth_method", "validate_access_token").assertEvent();
        }
    }

    private AccessTokenResponse executeGrantAccessTokenRequest(Client client) {
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget grantTarget = client.target(grantUri);
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        form.param("grant_type", "password").param("username", "test-user@localhost").param("password", "password");
        Response response = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        response.close();
        this.events.clear();
        return accessTokenResponse;
    }

    private void testSuccessfulUserInfoResponse(Response response) {
        this.events.expect(EventType.USER_INFO_REQUEST).session((Matcher<String>)Matchers.notNullValue(String.class)).detail("auth_method", "validate_access_token").detail("username", "test-user@localhost").assertEvent();
        UserInfoClientUtil.testSuccessfulUserInfoResponse((Response)response, (String)"test-user@localhost", (String)"test-user@localhost");
    }
}

