/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc.resptype;

import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Rule;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.util.OAuthClient;

public abstract class AbstractOIDCResponseTypeTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected OAuthGrantPage grantPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    protected void nonceMatches() {
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&nonce=abcdef123456");
        this.loginPage.assertCurrent();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        List<IDToken> idTokens = this.retrieveIDTokens(loginEvent);
        for (IDToken idToken : idTokens) {
            Assert.assertEquals((Object)"abcdef123456", (Object)idToken.getNonce());
        }
    }

    protected void nonceNotUsed() {
        this.driver.navigate().to(this.oauth.getLoginFormUrl());
        this.loginPage.assertCurrent();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        List<IDToken> idTokens = this.retrieveIDTokens(loginEvent);
        for (IDToken idToken : idTokens) {
            Assert.assertNull((Object)idToken.getNonce());
        }
    }

    protected void nonceNotUsedErrorExpected() {
        this.driver.navigate().to(this.oauth.getLoginFormUrl());
        org.junit.Assert.assertFalse((boolean)this.loginPage.isCurrent());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        OAuthClient.AuthorizationEndpointResponse resp = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertNull((Object)resp.getCode());
        Assert.assertNull((Object)resp.getIdToken());
        Assert.assertEquals((Object)"invalid_request", (Object)resp.getError());
        Assert.assertEquals((Object)"Missing parameter: nonce", (Object)resp.getErrorDescription());
    }

    protected abstract List<IDToken> retrieveIDTokens(EventRepresentation var1);
}

