/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc.resptype;

import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.oidc.resptype.AbstractOIDCResponseTypeTest;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;

public class OIDCBasicResponseTypeCodeTest
extends AbstractOIDCResponseTypeTest {
    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").standardFlow(true).implicitFlow(false);
        this.oauth.clientId("test-app");
        this.oauth.responseType("code");
    }

    @Override
    protected List<IDToken> retrieveIDTokens(EventRepresentation loginEvent) {
        Assert.assertEquals((Object)"code", loginEvent.getDetails().get("response_type"));
        OAuthClient.AuthorizationEndpointResponse authzResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth, false);
        Assert.assertNull((Object)authzResponse.getAccessToken());
        Assert.assertNull((Object)authzResponse.getIdToken());
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        return Collections.singletonList(idToken);
    }

    @Override
    @Test
    public void nonceNotUsed() {
        super.nonceNotUsed();
    }

    @Override
    @Test
    public void nonceMatches() {
        super.nonceMatches();
    }
}

