/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc.resptype;

import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.oidc.resptype.AbstractOIDCResponseTypeTest;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;

public class OIDCHybridResponseTypeCodeIDTokenTest
extends AbstractOIDCResponseTypeTest {
    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").standardFlow(true).implicitFlow(true);
        this.oauth.clientId("test-app");
        this.oauth.responseType("code id_token");
    }

    @Override
    protected List<IDToken> retrieveIDTokens(EventRepresentation loginEvent) {
        Assert.assertEquals((Object)"code id_token", loginEvent.getDetails().get("response_type"));
        OAuthClient.AuthorizationEndpointResponse authzResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth, true);
        Assert.assertNull((Object)authzResponse.getAccessToken());
        String idTokenStr = authzResponse.getIdToken();
        IDToken idToken = this.oauth.verifyIDToken(idTokenStr);
        IDToken idToken2 = this.sendTokenRequestAndGetIDToken(loginEvent);
        return Arrays.asList(idToken, idToken2);
    }

    @Override
    @Test
    public void nonceNotUsedErrorExpected() {
        super.nonceNotUsedErrorExpected();
    }

    @Override
    @Test
    public void nonceMatches() {
        super.nonceMatches();
    }
}

