/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.user;

import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.admin.ApiUtil;

public abstract class AbstractUserTest
extends AbstractAuthTest {
    protected UsersResource users() {
        return this.testRealmResource().users();
    }

    protected UserResource user(UserRepresentation user) {
        if (user.getId() == null) {
            throw new IllegalStateException("User id cannot be null.");
        }
        return this.user(user.getId());
    }

    protected UserResource user(String id) {
        return this.users().get(id);
    }

    public static UserRepresentation createUserRep(String username) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setEmail(username + "@email.test");
        return user;
    }

    public UserRepresentation createUser(UserRepresentation user) {
        return this.createUser(this.users(), user);
    }

    public UserRepresentation createUser(UsersResource users, UserRepresentation user) {
        Response response = users.create(user);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        user.setId(ApiUtil.getCreatedId(response));
        response.close();
        return user;
    }
}

