/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;

public class ClientManager {
    private static RealmResource realm;

    private ClientManager() {
    }

    public static ClientManager realm(RealmResource realm) {
        ClientManager.realm = realm;
        return new ClientManager();
    }

    public ClientManagerBuilder clientId(String clientId) {
        return new ClientManagerBuilder(ApiUtil.findClientByClientId(realm, clientId));
    }

    public class ClientManagerBuilder {
        private final ClientResource clientResource;

        public ClientManagerBuilder(ClientResource clientResource) {
            this.clientResource = clientResource;
        }

        public void renameTo(String newName) {
            ClientRepresentation app = this.clientResource.toRepresentation();
            app.setClientId(newName);
            this.clientResource.update(app);
        }

        public void enabled(Boolean enabled) {
            ClientRepresentation app = this.clientResource.toRepresentation();
            app.setEnabled(enabled);
            this.clientResource.update(app);
        }

        public void updateAttribute(String attribute, String value) {
            ClientRepresentation app = this.clientResource.toRepresentation();
            if (app.getAttributes() == null) {
                app.setAttributes(new LinkedHashMap());
            }
            app.getAttributes().put(attribute, value);
            this.clientResource.update(app);
        }

        public void directAccessGrant(Boolean enable) {
            ClientRepresentation app = this.clientResource.toRepresentation();
            app.setDirectAccessGrantsEnabled(enable);
            this.clientResource.update(app);
        }

        public ClientManagerBuilder standardFlow(Boolean enable) {
            ClientRepresentation app = this.clientResource.toRepresentation();
            app.setStandardFlowEnabled(enable);
            this.clientResource.update(app);
            return this;
        }

        public ClientManagerBuilder implicitFlow(Boolean enable) {
            ClientRepresentation app = this.clientResource.toRepresentation();
            app.setImplicitFlowEnabled(enable);
            this.clientResource.update(app);
            return this;
        }

        public void fullScopeAllowed(boolean enable) {
            ClientRepresentation app = this.clientResource.toRepresentation();
            app.setFullScopeAllowed(Boolean.valueOf(enable));
            this.clientResource.update(app);
        }

        public void consentRequired(boolean enable) {
            ClientRepresentation app = this.clientResource.toRepresentation();
            app.setConsentRequired(Boolean.valueOf(enable));
            this.clientResource.update(app);
        }

        public ClientManagerBuilder addProtocolMapper(ProtocolMapperRepresentation protocolMapper) {
            this.clientResource.getProtocolMappers().createMapper(protocolMapper);
            return this;
        }

        public void addScopeMapping(RoleRepresentation newRole) {
            this.clientResource.getScopeMappings().realmLevel().add(Collections.singletonList(newRole));
        }

        public ClientManagerBuilder removeProtocolMapper(String protocolMapperName) {
            ProtocolMapperRepresentation rep = ApiUtil.findProtocolMapperByName(this.clientResource, protocolMapperName);
            this.clientResource.getProtocolMappers().delete(rep.getId());
            return this;
        }

        public void removeScopeMapping(RoleRepresentation newRole) {
            this.clientResource.getScopeMappings().realmLevel().remove(Collections.singletonList(newRole));
        }

        public void addRedirectUris(String ... redirectUris) {
            ClientRepresentation app = this.clientResource.toRepresentation();
            if (app.getRedirectUris() == null) {
                app.setRedirectUris(new LinkedList());
            }
            for (String redirectUri : redirectUris) {
                app.getRedirectUris().add(redirectUri);
            }
            this.clientResource.update(app);
        }

        public void removeRedirectUris(String ... redirectUris) {
            ClientRepresentation app = this.clientResource.toRepresentation();
            for (String redirectUri : redirectUris) {
                if (app.getRedirectUris() == null) continue;
                app.getRedirectUris().remove(redirectUri);
            }
            this.clientResource.update(app);
        }
    }
}

