/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;

public class KeycloakModelUtils {
    public static ClientRepresentation createClient(RealmRepresentation realm, String name) {
        ClientRepresentation app = new ClientRepresentation();
        app.setName(name);
        app.setClientId(name);
        realm.getClients().add(app);
        app.setClientAuthenticatorType(org.keycloak.models.utils.KeycloakModelUtils.getDefaultClientAuthenticatorType());
        KeycloakModelUtils.generateSecret(app);
        app.setFullScopeAllowed(Boolean.valueOf(true));
        return app;
    }

    public static CredentialRepresentation generateSecret(ClientRepresentation client) {
        UserCredentialModel secret = UserCredentialModel.generateSecret();
        client.setSecret(secret.getValue());
        return ModelToRepresentation.toRepresentation((UserCredentialModel)secret);
    }
}

