/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.keycloak.testsuite.util.MailServer;
import org.keycloak.testsuite.util.SslMailServer;

public class MailAssert {
    private static final Logger log = Logger.getLogger(MailAssert.class);

    public static String assertEmailAndGetUrl(String from, String recipient, String content, Boolean sslEnabled) {
        try {
            String messageContent;
            MimeMessage message = sslEnabled != false ? SslMailServer.getLastReceivedMessage() : MailServer.getLastReceivedMessage();
            Assert.assertNotNull((String)"There is no received email.", (Object)message);
            Assert.assertEquals((Object)recipient, (Object)message.getRecipients(MimeMessage.RecipientType.TO)[0].toString());
            Assert.assertEquals((Object)from, (Object)message.getFrom()[0].toString());
            if (message.getContent() instanceof MimeMultipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
                messageContent = String.valueOf(mimeMultipart.getBodyPart(0).getContent());
            } else {
                messageContent = String.valueOf(message.getContent());
            }
            MailAssert.logMessageContent(messageContent);
            String errorMessage = "Email content should contains \"" + content + "\", but it doesn't.\nEmail content:\n" + messageContent + "\n";
            Assert.assertTrue((String)errorMessage, (boolean)messageContent.contains(content));
            for (String string : messageContent.split("\n")) {
                if (!string.contains("http://")) continue;
                return string;
            }
            return null;
        }
        catch (IOException | InterruptedException | MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void logMessageContent(String messageContent) {
        log.debug((Object)"---------------------");
        log.debug((Object)messageContent);
        log.debug((Object)"---------------------");
    }
}

