/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class RealmBuilder {
    private final RealmRepresentation rep;

    public static RealmBuilder create() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setEnabled(Boolean.TRUE);
        return new RealmBuilder(rep);
    }

    public static RealmBuilder edit(RealmRepresentation rep) {
        return new RealmBuilder(rep);
    }

    private RealmBuilder(RealmRepresentation rep) {
        this.rep = rep;
    }

    public RealmBuilder name(String name) {
        this.rep.setRealm(name);
        return this;
    }

    public RealmBuilder publicKey(String publicKey) {
        this.rep.setPublicKey(publicKey);
        return this;
    }

    public RealmBuilder privateKey(String privateKey) {
        this.rep.setPrivateKey(privateKey);
        return this;
    }

    public RealmBuilder roles(RolesBuilder roles) {
        return this.roles(roles.build());
    }

    public RealmBuilder roles(RolesRepresentation roles) {
        this.rep.setRoles(roles);
        return this;
    }

    public RealmBuilder events() {
        this.rep.setEventsEnabled(true);
        this.rep.setEnabledEventTypes(Collections.emptyList());
        return this;
    }

    public RealmBuilder testMail() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("from", "server@mail.test");
        config.put("host", "localhost");
        config.put("port", "3025");
        this.rep.setSmtpServer(config);
        return this;
    }

    public RealmBuilder testEventListener() {
        if (this.rep.getEventsListeners() == null) {
            this.rep.setEventsListeners(new LinkedList());
        }
        if (!this.rep.getEventsListeners().contains("event-queue")) {
            this.rep.getEventsListeners().add("event-queue");
        }
        return this;
    }

    public RealmBuilder removeTestEventListener() {
        if (this.rep.getEventsListeners() != null && this.rep.getEventsListeners().contains("event-queue")) {
            this.rep.getEventsListeners().remove("event-queue");
        }
        return this;
    }

    public RealmBuilder client(ClientBuilder client) {
        return this.client(client.build());
    }

    public RealmBuilder client(ClientRepresentation client) {
        if (this.rep.getClients() == null) {
            this.rep.setClients(new LinkedList());
        }
        this.rep.getClients().add(client);
        return this;
    }

    public RealmBuilder user(UserBuilder user) {
        return this.user(user.build());
    }

    public RealmBuilder user(UserRepresentation user) {
        if (this.rep.getUsers() == null) {
            this.rep.setUsers(new LinkedList());
        }
        this.rep.getUsers().add(user);
        return this;
    }

    public RealmBuilder notBefore(int i) {
        this.rep.setNotBefore(Integer.valueOf(i));
        return this;
    }

    public RealmBuilder otpLookAheadWindow(int i) {
        this.rep.setOtpPolicyLookAheadWindow(Integer.valueOf(i));
        return this;
    }

    public RealmBuilder bruteForceProtected(boolean bruteForceProtected) {
        this.rep.setBruteForceProtected(Boolean.valueOf(bruteForceProtected));
        return this;
    }

    public RealmBuilder failureFactor(int failureFactor) {
        this.rep.setFailureFactor(Integer.valueOf(failureFactor));
        return this;
    }

    public RealmBuilder otpDigits(int i) {
        this.rep.setOtpPolicyDigits(Integer.valueOf(i));
        return this;
    }

    public RealmBuilder otpPeriod(int i) {
        this.rep.setOtpPolicyPeriod(Integer.valueOf(i));
        return this;
    }

    public RealmBuilder otpType(String type) {
        this.rep.setOtpPolicyType(type);
        return this;
    }

    public RealmBuilder otpAlgorithm(String algorithm) {
        this.rep.setOtpPolicyAlgorithm(algorithm);
        return this;
    }

    public RealmBuilder otpInitialCounter(int i) {
        this.rep.setOtpPolicyInitialCounter(Integer.valueOf(i));
        return this;
    }

    public RealmBuilder passwordPolicy(String passwordPolicy) {
        this.rep.setPasswordPolicy(passwordPolicy);
        return this;
    }

    public RealmRepresentation build() {
        return this.rep;
    }

    public RealmBuilder accessTokenLifespan(int accessTokenLifespan) {
        this.rep.setAccessTokenLifespan(Integer.valueOf(accessTokenLifespan));
        return this;
    }

    public RealmBuilder ssoSessionMaxLifespan(int ssoSessionMaxLifespan) {
        this.rep.setSsoSessionMaxLifespan(Integer.valueOf(ssoSessionMaxLifespan));
        return this;
    }

    public RealmBuilder accessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.rep.setAccessCodeLifespanUserAction(Integer.valueOf(accessCodeLifespanUserAction));
        return this;
    }

    public RealmBuilder accessCodeLifespan(int accessCodeLifespan) {
        this.rep.setAccessCodeLifespan(Integer.valueOf(accessCodeLifespan));
        return this;
    }

    public RealmBuilder sslRequired(String sslRequired) {
        this.rep.setSslRequired(sslRequired);
        return this;
    }

    public RealmBuilder ssoSessionIdleTimeout(int sessionIdleTimeout) {
        this.rep.setSsoSessionIdleTimeout(Integer.valueOf(sessionIdleTimeout));
        return this;
    }
}

