/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jboss.logging.Logger;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.openqa.selenium.WebDriver;

public class TestEventsLogger
extends RunListener {
    private static WebDriver driver;

    public static void setDriver(WebDriver driver) {
        TestEventsLogger.driver = driver;
    }

    private Logger log(Description d) {
        return Logger.getLogger((String)d.getClassName());
    }

    private String getMessage(Description d, String status) {
        return String.format("[%s] %s() %s", d.getTestClass().getSimpleName(), d.getMethodName(), status);
    }

    public void testStarted(Description d) throws Exception {
        this.log(d).info((Object)this.getMessage(d, "STARTED"));
    }

    public void testFailure(Failure f) throws Exception {
        Description d = f.getDescription();
        this.createPageSrcFile(d);
        this.log(d).error((Object)this.getMessage(d, "FAILED"));
    }

    public void testIgnored(Description d) throws Exception {
        this.log(d).warn((Object)this.getMessage(d, "IGNORED\n\n"));
    }

    public void testFinished(Description d) throws Exception {
        this.log(d).info((Object)this.getMessage(d, "FINISHED\n\n"));
    }

    private void createPageSrcFile(Description d) throws IOException {
        if (driver != null && driver.getPageSource() != null) {
            String pageSourceLocation = System.getProperty("page.source.location", "target/failed-tests/page-source/");
            FileUtils.writeStringToFile((File)new File(pageSourceLocation + d.getTestClass().getSimpleName() + "/" + d.getMethodName() + ".html"), (String)driver.getPageSource());
        }
    }
}

