/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.Assert;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.URLUtils;
import org.openqa.selenium.WebDriver;

public class URLAssert {
    public static void assertCurrentUrlEquals(AbstractPage page) {
        URLAssert.assertCurrentUrlEquals(page.getDriver(), page);
    }

    public static void assertCurrentUrlEquals(WebDriver driver, AbstractPage page) {
        String expected = page.toString();
        Assert.assertTrue((String)("Expected URL: " + expected + "; actual: " + driver.getCurrentUrl()), (boolean)URLUtils.currentUrlEqual((WebDriver)driver, (String)page.toString()));
    }

    public static void assertCurrentUrlStartsWith(AbstractPage page) {
        URLAssert.assertCurrentUrlStartsWith(page.getDriver(), page.toString());
    }

    public static void assertCurrentUrlStartsWith(WebDriver driver, String url) {
        Assert.assertTrue((String)("URL expected to begin with:" + url + "; actual URL: " + driver.getCurrentUrl()), (boolean)URLUtils.currentUrlStartWith((WebDriver)driver, (String)url));
    }

    public static void assertCurrentUrlDoesntStartWith(AbstractPage page) {
        URLAssert.assertCurrentUrlDoesntStartWith(page.getDriver(), page.toString());
    }

    public static void assertCurrentUrlDoesntStartWith(WebDriver driver, String url) {
        Assert.assertTrue((String)("URL expected NOT to begin with:" + url + "; actual URL: " + driver.getCurrentUrl()), (boolean)URLUtils.currentUrlDoesntStartWith((WebDriver)driver, (String)url));
    }

    public static void assertCurrentUrlStartsWithLoginUrlOf(PageWithLoginUrl page) {
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf(page.getDriver(), page);
    }

    public static void assertCurrentUrlStartsWithLoginUrlOf(WebDriver driver, PageWithLoginUrl page) {
        URLAssert.assertCurrentUrlStartsWith(driver, page.getOIDCLoginUrl().toString());
    }

    public static void assertGetURL(URI url, String accessToken, AssertResponseHandler handler) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpGet get = new HttpGet(url);
            get.setHeader("Authorization", "Bearer " + accessToken);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Response status error: " + response.getStatusLine().getStatusCode() + ": " + url);
            }
            handler.assertResponse(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static abstract class AssertJSONResponseHandler
    implements AssertResponseHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void assertResponse(CloseableHttpResponse response) throws IOException {
            HttpEntity entity = response.getEntity();
            Header contentType = entity.getContentType();
            Assert.assertEquals((Object)"application/json", (Object)contentType.getValue());
            char[] buf = new char[8192];
            StringWriter out = new StringWriter();
            InputStreamReader in = new InputStreamReader(entity.getContent(), Charset.forName("utf-8"));
            int rc = 0;
            try {
                while ((rc = in.read(buf)) != -1) {
                    out.write(buf, 0, rc);
                }
            }
            finally {
                try {
                    ((Reader)in).close();
                }
                catch (Exception exception) {}
                out.close();
            }
            this.assertResponseBody(out.toString());
        }

        protected abstract void assertResponseBody(String var1) throws IOException;
    }

    public static interface AssertResponseHandler {
        public void assertResponse(CloseableHttpResponse var1) throws IOException;
    }
}

