/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;

public class UserFederationProviderBuilder {
    private String id;
    private String displayName;
    private String providerName;
    private Map<String, String> config;
    private int priority = 1;
    private int fullSyncPeriod = -1;
    private int changedSyncPeriod = -1;
    private int lastSync = -1;

    private UserFederationProviderBuilder() {
    }

    public static UserFederationProviderBuilder create() {
        return new UserFederationProviderBuilder();
    }

    public void setId(String id) {
        this.id = id;
    }

    public UserFederationProviderBuilder displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public UserFederationProviderBuilder providerName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    public UserFederationProviderBuilder configProperty(String key, String value) {
        if (this.config == null) {
            this.config = new HashMap<String, String>();
        }
        this.config.put(key, value);
        return this;
    }

    public UserFederationProviderBuilder removeConfigProperty(String key) {
        if (this.config != null) {
            this.config.remove(key);
        }
        return this;
    }

    public UserFederationProviderBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public UserFederationProviderBuilder fullSyncPeriod(int fullSyncPeriod) {
        this.fullSyncPeriod = fullSyncPeriod;
        return this;
    }

    public UserFederationProviderBuilder changedSyncPeriod(int changedSyncPeriod) {
        this.changedSyncPeriod = changedSyncPeriod;
        return this;
    }

    public UserFederationProviderBuilder lastSync(int lastSync) {
        this.lastSync = lastSync;
        return this;
    }

    public UserFederationProviderRepresentation build() {
        UserFederationProviderRepresentation rep = new UserFederationProviderRepresentation();
        rep.setId(this.id);
        rep.setDisplayName(this.displayName);
        rep.setProviderName(this.providerName);
        rep.setConfig(this.config);
        rep.setPriority(this.priority);
        rep.setFullSyncPeriod(this.fullSyncPeriod);
        rep.setChangedSyncPeriod(this.changedSyncPeriod);
        rep.setLastSync(this.lastSync);
        return rep;
    }
}

