/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.page;

import java.net.URL;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.keycloak.testsuite.page.AbstractPageWithInjectedUrl;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.WebElement;

public class CustomerPortalExample
extends AbstractPageWithInjectedUrl {
    public static final String DEPLOYMENT_NAME = "customer-portal-example";
    @ArquillianResource
    @OperateOnDeployment(value="customer-portal-example")
    private URL url;
    @FindByJQuery(value="h1:contains('Customer Portal')")
    private WebElement title;
    @FindByJQuery(value="a:contains('Customer Listing')")
    private WebElement customerListingLink;
    @FindByJQuery(value="h1:contains('Customer Listing')")
    private WebElement customerListingHeader;
    @FindByJQuery(value="h1:contains('Customer Session')")
    private WebElement customerSessionHeader;
    @FindByJQuery(value="a:contains('Customer Admin Interface')")
    private WebElement customerAdminInterfaceLink;
    @FindByJQuery(value="a:contains('Customer Session')")
    private WebElement customerSessionLink;
    @FindByJQuery(value="a:contains('products')")
    private WebElement productsLink;
    @FindByJQuery(value="a:contains('logout')")
    private WebElement logOutButton;

    @Override
    public URL getInjectedUrl() {
        URL fixedUrl = this.createInjectedURL("customer-portal");
        return fixedUrl != null ? fixedUrl : this.url;
    }

    public void goToProducts() {
        this.productsLink.click();
    }

    public void customerListing() {
        this.customerListingLink.click();
    }

    public void customerAdminInterface() {
        this.customerAdminInterfaceLink.click();
    }

    public void customerSession() {
        WaitUtils.waitUntilElement(this.customerSessionLink).is().present();
        this.customerSessionLink.click();
    }

    public void logOut() {
        this.logOutButton.click();
    }

    public void waitForCustomerListingHeader() {
        ((IsElementBuilder)WaitUtils.waitUntilElement(this.customerListingHeader).is().not()).present();
    }

    public void waitForCustomerSessionHeader() {
        ((IsElementBuilder)WaitUtils.waitUntilElement(this.customerSessionHeader).is().not()).present();
    }
}

