/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.page;

import java.net.URL;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.keycloak.testsuite.page.AbstractPageWithInjectedUrl;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

public class JSConsoleTestApp
extends AbstractPageWithInjectedUrl {
    public static final String DEPLOYMENT_NAME = "js-console-example";
    public static final String CLIENT_ID = "integration-arquillian-test-apps-js-console";
    @ArquillianResource
    @OperateOnDeployment(value="js-console-example")
    private URL url;
    @FindBy(xpath="//button[text() = 'Init']")
    private WebElement initButton;
    @FindBy(xpath="//button[text() = 'Login']")
    private WebElement logInButton;
    @FindBy(xpath="//button[text() = 'Logout']")
    private WebElement logOutButton;
    @FindBy(xpath="//button[text() = 'Refresh Token']")
    private WebElement refreshTokenButton;
    @FindBy(xpath="//button[contains(text(),'Refresh Token (if <30s')]")
    private WebElement refreshTokenIfUnder30sButton;
    @FindBy(xpath="//button[text() = 'Get Profile']")
    private WebElement getProfileButton;
    @FindBy(xpath="//button[text() = 'Show Error Response']")
    private WebElement showErrorButton;
    @FindBy(xpath="//button[text() = 'Show Token']")
    private WebElement showTokenButton;
    @FindBy(xpath="//button[text() = 'Show Refresh Token']")
    private WebElement showRefreshTokenButton;
    @FindBy(xpath="//button[text() = 'Show ID Token']")
    private WebElement showIdTokenButton;
    @FindBy(xpath="//button[text() = 'Show Expires']")
    private WebElement showExpiresButton;
    @FindBy(xpath="//button[text() = 'Show Details']")
    private WebElement showDetailsButton;
    @FindBy(xpath="//button[text() = 'Create Bearer Request']")
    private WebElement createBearerRequest;
    @FindBy(id="flowSelect")
    private Select flowSelect;
    @FindBy(id="responseModeSelect")
    private Select responseModeSelect;
    @FindBy(id="onLoad")
    private Select onLoad;
    @FindBy(id="output")
    private WebElement outputArea;
    @FindBy(id="events")
    private WebElement eventsArea;

    @Override
    public URL getInjectedUrl() {
        URL fixedUrl = this.createInjectedURL("js-console");
        return fixedUrl != null ? fixedUrl : this.url;
    }

    public void logIn() {
        this.logInButton.click();
    }

    public void logOut() {
        this.logOutButton.click();
    }

    public void refreshToken() {
        this.refreshTokenButton.click();
    }

    public void refreshTokenIfUnder30s() {
        this.refreshTokenIfUnder30sButton.click();
    }

    public void getProfile() {
        this.getProfileButton.click();
    }

    public void setFlow(String value) {
        this.flowSelect.selectByValue(value);
    }

    public void setOnLoad(String value) {
        this.onLoad.selectByValue(value);
    }

    public void init() {
        this.initButton.click();
    }

    public void createBearerRequest() {
        this.createBearerRequest.click();
    }

    public void setResponseMode(String value) {
        this.responseModeSelect.selectByValue(value);
    }

    public WebElement getOutputElement() {
        return this.outputArea;
    }

    public WebElement getEventsElement() {
        return this.eventsArea;
    }

    public WebElement getInitButtonElement() {
        return this.initButton;
    }

    public void showErrorResponse() {
        this.showErrorButton.click();
    }
}

