/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.page;

import java.net.URL;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.page.AbstractPageWithInjectedUrl;
import org.keycloak.testsuite.page.Form;
import org.keycloak.testsuite.pages.ConsentPage;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class PhotozClientAuthzTestApp
extends AbstractPageWithInjectedUrl {
    public static final String DEPLOYMENT_NAME = "photoz-html5-client";
    public static final int WAIT_AFTER_OPERATION = 2000;
    @ArquillianResource
    @OperateOnDeployment(value="photoz-html5-client")
    private URL url;
    @Page
    protected OIDCLogin loginPage;
    @Page
    protected ConsentPage consentPage;
    @FindBy(xpath="//a[@ng-click = 'Identity.logout()']")
    WebElement signOutButton;

    public void createAlbum(String name) {
        this.navigateTo();
        this.driver.findElement(By.id((String)"create-album")).click();
        Form.setInputValue(this.driver.findElement(By.id((String)"album.name")), name);
        WaitUtils.pause(200L);
        this.driver.findElement(By.id((String)"save-album")).click();
        WaitUtils.pause(2000L);
    }

    @Override
    public URL getInjectedUrl() {
        return this.url;
    }

    public void deleteAlbum(String name) {
        this.driver.findElements(By.xpath((String)("//a[text()='" + name + "']/following-sibling::a[text()='X']"))).forEach(WebElement::click);
        WaitUtils.pause(2000L);
    }

    public void navigateToAdminAlbum() {
        URLUtils.navigateToUri(this.driver, this.toString() + "/#/admin/album", true);
        this.driver.navigate().refresh();
        WaitUtils.waitForPageToLoad(this.driver);
        WaitUtils.pause(2000L);
    }

    public void logOut() {
        this.signOutButton.click();
        WaitUtils.pause(2000L);
    }

    public void login(String username, String password, String ... scopes) {
        if (scopes.length > 0) {
            StringBuilder scopesValue = new StringBuilder();
            for (String scope : scopes) {
                if (scopesValue.length() != 0) {
                    scopesValue.append(" ");
                }
                scopesValue.append(scope);
            }
            URLUtils.navigateToUri(this.driver, this.driver.getCurrentUrl() + " " + scopesValue, true);
        }
        this.loginPage.form().login(username, password);
        if (this.consentPage.isCurrent()) {
            this.consentPage.confirm();
        }
        WaitUtils.pause(2000L);
    }

    public boolean wasDenied() {
        return this.driver.findElement(By.id((String)"output")).getText().contains("You can not access");
    }

    public void viewAlbum(String name) throws InterruptedException {
        this.driver.findElement(By.xpath((String)("//a[text() = '" + name + "']"))).click();
        WaitUtils.waitForPageToLoad(this.driver);
        this.driver.navigate().refresh();
        WaitUtils.pause(2000L);
    }

    @Override
    public void navigateTo(boolean waitForMatch) {
        super.navigateTo(waitForMatch);
        WaitUtils.pause(2000L);
    }

    @Override
    public boolean isCurrent() {
        return URLUtils.currentUrlStartWith(this.driver, this.toString());
    }
}

