/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.page;

import java.net.URL;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.keycloak.testsuite.page.AbstractPageWithInjectedUrl;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.WebElement;

public class ProductPortalExample
extends AbstractPageWithInjectedUrl {
    public static final String DEPLOYMENT_NAME = "product-portal-example";
    @ArquillianResource
    @OperateOnDeployment(value="product-portal-example")
    private URL url;
    @FindByJQuery(value="h1:contains('Product Portal')")
    private WebElement title;
    @FindByJQuery(value="a:contains('Product Listing')")
    private WebElement productListingLink;
    @FindByJQuery(value="h1:contains('Product Listing')")
    private WebElement productListingHeader;
    @FindByJQuery(value="a:contains('customers')")
    private WebElement customersLink;
    @FindByJQuery(value="a:contains('logout')")
    private WebElement logOutButton;

    @Override
    public URL getInjectedUrl() {
        URL fixedUrl = this.createInjectedURL("product-portal");
        return fixedUrl != null ? fixedUrl : this.url;
    }

    public void productListing() {
        this.productListingLink.click();
    }

    public void goToCustomers() {
        this.customersLink.click();
    }

    public void waitForProductListingHeader() {
        ((IsElementBuilder)WaitUtils.waitUntilElement(this.productListingHeader).is().not()).present();
    }

    public void logOut() {
        this.logOutButton.click();
    }
}

