/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;

@Path(value="/")
public class SendUsernameServlet {
    private static boolean checkRoles = false;
    @Context
    private HttpServletRequest httpServletRequest;

    @GET
    @NoCache
    public Response doGet(@QueryParam(value="checkRoles") boolean checkRolesFlag) throws ServletException, IOException {
        System.out.println("In SendUsername Servlet doGet() check roles is " + (checkRolesFlag || checkRoles));
        if (this.httpServletRequest.getUserPrincipal() != null && (checkRolesFlag || checkRoles) && !this.checkRoles()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Forbidden").build();
        }
        return Response.ok((Object)this.getOutput(), (String)"text/plain").build();
    }

    @POST
    @NoCache
    public Response doPost(@QueryParam(value="checkRoles") boolean checkRolesFlag) throws ServletException, IOException {
        System.out.println("In SendUsername Servlet doPost() check roles is " + (checkRolesFlag || checkRoles));
        if (this.httpServletRequest.getUserPrincipal() != null && (checkRolesFlag || checkRoles) && !this.checkRoles()) {
            throw new RuntimeException("User: " + this.httpServletRequest.getUserPrincipal() + " do not have required role");
        }
        return Response.ok((Object)this.getOutput(), (String)"text/plain").build();
    }

    @GET
    @Path(value="{path}")
    public Response doGetElseWhere(@PathParam(value="path") String path, @QueryParam(value="checkRoles") boolean checkRolesFlag) throws ServletException, IOException {
        System.out.println("In SendUsername Servlet doGetElseWhere() - path: " + path);
        return this.doGet(checkRolesFlag);
    }

    @POST
    @Path(value="{path}")
    public Response doPostElseWhere(@PathParam(value="path") String path, @QueryParam(value="checkRoles") boolean checkRolesFlag) throws ServletException, IOException {
        System.out.println("In SendUsername Servlet doPostElseWhere() - path: " + path);
        return this.doPost(checkRolesFlag);
    }

    @GET
    @Path(value="checkRoles")
    public String checkRolesEndPoint() {
        checkRoles = true;
        System.out.println("Setting checkRoles to true");
        return "Roles will be checked";
    }

    private boolean checkRoles() {
        return this.httpServletRequest.isUserInRole("manager");
    }

    private String getOutput() {
        String output = "request-path: ";
        output = output + this.httpServletRequest.getServletPath();
        output = output + "\n";
        output = output + "principal=";
        Principal principal = this.httpServletRequest.getUserPrincipal();
        if (principal == null) {
            return output + "null";
        }
        return output + principal.getName();
    }
}

