/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.event.StartContainer;
import org.jboss.arquillian.container.spi.event.StartSuiteContainers;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.util.LogChecker;
import org.keycloak.testsuite.util.OAuthClient;

public class AuthServerTestEnricher {
    protected final Logger log = Logger.getLogger(this.getClass());
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<ContainerController> containerController;
    @Inject
    private Event<StartContainer> startContainerEvent;
    private static final String AUTH_SERVER_CONTAINER_DEFAULT = "auth-server-undertow";
    private static final String AUTH_SERVER_CONTAINER_PROPERTY = "auth.server.container";
    public static final String AUTH_SERVER_CONTAINER = System.getProperty("auth.server.container", "auth-server-undertow");
    private static final String AUTH_SERVER_CLUSTER_PROPERTY = "auth.server.cluster";
    public static final boolean AUTH_SERVER_CLUSTER = Boolean.parseBoolean(System.getProperty("auth.server.cluster", "false"));
    private static final String MIGRATED_AUTH_SERVER_CONTAINER_PROPERTY = "migrated.auth.server.container";
    public static final String MIGRATED_AUTH_SERVER_CONTAINER = System.getProperty("migrated.auth.server.container");
    @Inject
    @SuiteScoped
    private InstanceProducer<SuiteContext> suiteContextProducer;
    private SuiteContext suiteContext;
    @Inject
    @ClassScoped
    private InstanceProducer<TestContext> testContextProducer;
    @Inject
    @ClassScoped
    private InstanceProducer<OAuthClient> oAuthClientProducer;

    public static String getAuthServerContextRoot() {
        return AuthServerTestEnricher.getAuthServerContextRoot(0);
    }

    public static String getAuthServerContextRoot(int clusterPortOffset) {
        String host = System.getProperty("auth.server.host", "localhost");
        int httpPort = Integer.parseInt(System.getProperty("auth.server.http.port"));
        int httpsPort = Integer.parseInt(System.getProperty("auth.server.https.port"));
        boolean sslRequired = Boolean.parseBoolean(System.getProperty("auth.server.ssl.required"));
        String scheme = sslRequired ? "https" : "http";
        int port = sslRequired ? httpsPort : httpPort;
        return String.format("%s://%s:%s", scheme, host, port + clusterPortOffset);
    }

    public void initializeSuiteContext(@Observes(precedence=2) BeforeSuite event) {
        LinkedHashSet<ContainerInfo> containers = new LinkedHashSet<ContainerInfo>();
        for (Container c : ((ContainerRegistry)this.containerRegistry.get()).getContainers()) {
            containers.add(new ContainerInfo(c));
        }
        this.suiteContext = new SuiteContext(containers);
        String authServerFrontend = AUTH_SERVER_CLUSTER ? "auth-server-balancer-wildfly" : AUTH_SERVER_CONTAINER;
        String authServerBackend = AUTH_SERVER_CONTAINER + "-backend";
        int backends = 0;
        for (ContainerInfo container : this.suiteContext.getContainers()) {
            if (container.getQualifier().equals(authServerFrontend)) {
                this.updateWithAuthServerInfo(container);
                this.suiteContext.setAuthServerInfo(container);
            }
            if (!AUTH_SERVER_CLUSTER || !container.getQualifier().startsWith(authServerBackend)) continue;
            this.updateWithAuthServerInfo(container, ++backends);
            this.suiteContext.getAuthServerBackendsInfo().add(container);
        }
        if (this.suiteContext.getAuthServerInfo() == null) {
            throw new RuntimeException(String.format("No auth server container matching '%s' found in arquillian.xml.", authServerFrontend));
        }
        if (AUTH_SERVER_CLUSTER && this.suiteContext.getAuthServerBackendsInfo().isEmpty()) {
            throw new RuntimeException(String.format("No auth server container matching '%sN' found in arquillian.xml.", authServerBackend));
        }
        if (MIGRATED_AUTH_SERVER_CONTAINER != null) {
            if (MIGRATED_AUTH_SERVER_CONTAINER.startsWith("migrated-auth-server-")) {
                for (ContainerInfo container : this.suiteContext.getContainers()) {
                    if (!container.getQualifier().equals(MIGRATED_AUTH_SERVER_CONTAINER)) continue;
                    this.updateWithAuthServerInfo(container);
                    this.suiteContext.setMigratedAuthServerInfo(container);
                }
            } else {
                throw new IllegalArgumentException(String.format("Value of %s should start with 'migrated-auth-server-' prefix.", MIGRATED_AUTH_SERVER_CONTAINER_PROPERTY));
            }
            if (this.suiteContext.getMigratedAuthServerInfo() == null) {
                throw new RuntimeException(String.format("Migration test was enabled but no auth server from which to migrate was activated. A container matching '%s' needs to be enabled in arquillian.xml.", MIGRATED_AUTH_SERVER_CONTAINER));
            }
        }
        this.suiteContextProducer.set((Object)this.suiteContext);
        this.log.info((Object)("\n\n" + this.suiteContext));
    }

    private ContainerInfo updateWithAuthServerInfo(ContainerInfo authServerInfo) {
        return this.updateWithAuthServerInfo(authServerInfo, 0);
    }

    private ContainerInfo updateWithAuthServerInfo(ContainerInfo authServerInfo, int clusterPortOffset) {
        try {
            authServerInfo.setContextRoot(new URL(AuthServerTestEnricher.getAuthServerContextRoot(clusterPortOffset)));
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        return authServerInfo;
    }

    public void startMigratedContainer(@Observes(precedence=2) StartSuiteContainers event) {
        if (this.suiteContext.isAuthServerMigrationEnabled()) {
            this.log.info((Object)("\n\n### Starting keycloak " + System.getProperty("version", "- previous") + " ###\n"));
            this.startContainerEvent.fire((Object)new StartContainer(this.suiteContext.getMigratedAuthServerInfo().getArquillianContainer()));
        }
    }

    public void stopMigratedContainer(@Observes(precedence=1) StartSuiteContainers event) {
        if (this.suiteContext.isAuthServerMigrationEnabled()) {
            ((ContainerController)this.containerController.get()).stop(this.suiteContext.getAuthServerInfo().getQualifier());
        }
    }

    public void checkServerLogs(@Observes(precedence=-1) BeforeSuite event) throws IOException, InterruptedException {
        boolean checkLog = Boolean.parseBoolean(System.getProperty("auth.server.log.check", "true"));
        if (checkLog && this.suiteContext.getAuthServerInfo().isJBossBased()) {
            String jbossHomePath = this.suiteContext.getAuthServerInfo().getProperties().get("jbossHome");
            LogChecker.checkJBossServerLog(jbossHomePath);
        }
    }

    public void initializeTestContext(@Observes(precedence=2) BeforeClass event) {
        TestContext testContext = new TestContext(this.suiteContext, event.getTestClass().getJavaClass());
        this.testContextProducer.set((Object)testContext);
    }

    public void initializeOAuthClient(@Observes(precedence=3) BeforeClass event) {
        OAuthClient oAuthClient = new OAuthClient();
        this.oAuthClientProducer.set((Object)oAuthClient);
    }
}

