/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.util.List;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.test.impl.client.deployment.AnnotationDeploymentScenarioGenerator;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;

public class DeploymentTargetModifier
extends AnnotationDeploymentScenarioGenerator {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public List<DeploymentDescription> generate(TestClass testClass) {
        List deployments = super.generate(testClass);
        String appServerQualifier = AppServerTestEnricher.getAppServerQualifier(testClass.getJavaClass());
        if (appServerQualifier != null && !appServerQualifier.isEmpty()) {
            for (DeploymentDescription deployment : deployments) {
                if (deployment.getTarget() != null && deployment.getTarget().getName().equals(appServerQualifier)) continue;
                this.log.debug((Object)("Setting target container for " + deployment.getName() + ": " + appServerQualifier));
                deployment.setTarget(new TargetDescription(appServerQualifier));
            }
        }
        return deployments;
    }
}

