/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.testsuite.arquillian.ContainerInfo;

public final class SuiteContext {
    private final Set<ContainerInfo> container;
    private ContainerInfo authServerInfo;
    private final List<ContainerInfo> authServerBackendsInfo = new ArrayList<ContainerInfo>();
    private ContainerInfo migratedAuthServerInfo;
    private boolean adminPasswordUpdated;
    private final Map<String, String> smtpServer = new HashMap<String, String>();

    public SuiteContext(Set<ContainerInfo> arquillianContainers) {
        this.container = arquillianContainers;
        this.adminPasswordUpdated = false;
        this.smtpServer.put("from", "server@mail.test");
        this.smtpServer.put("host", "localhost");
        this.smtpServer.put("port", "3025");
    }

    public boolean isAdminPasswordUpdated() {
        return this.adminPasswordUpdated;
    }

    public void setAdminPasswordUpdated(boolean adminPasswordUpdated) {
        this.adminPasswordUpdated = adminPasswordUpdated;
    }

    public Map<String, String> getSmtpServer() {
        return this.smtpServer;
    }

    public ContainerInfo getAuthServerInfo() {
        return this.authServerInfo;
    }

    public void setAuthServerInfo(ContainerInfo authServerInfo) {
        this.authServerInfo = authServerInfo;
    }

    public List<ContainerInfo> getAuthServerBackendsInfo() {
        return this.authServerBackendsInfo;
    }

    public ContainerInfo getMigratedAuthServerInfo() {
        return this.migratedAuthServerInfo;
    }

    public void setMigratedAuthServerInfo(ContainerInfo migratedAuthServerInfo) {
        this.migratedAuthServerInfo = migratedAuthServerInfo;
    }

    public boolean isAuthServerCluster() {
        return !this.authServerBackendsInfo.isEmpty();
    }

    public boolean isAuthServerMigrationEnabled() {
        return this.migratedAuthServerInfo != null;
    }

    public Set<ContainerInfo> getContainers() {
        return this.container;
    }

    public String toString() {
        String containers = "Auth server: " + (this.isAuthServerCluster() ? "\nFrontend: " : "") + this.authServerInfo.getQualifier() + "\n";
        for (ContainerInfo bInfo : this.getAuthServerBackendsInfo()) {
            containers = containers + "Backend: " + bInfo + "\n";
        }
        return "SUITE CONTEXT:\n" + containers;
    }
}

