/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.provider;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.impl.enricher.resource.URLResourceProvider;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.AppServerContext;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContext;

public class URLProvider
extends URLResourceProvider {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    public static final String LOCALHOST_ADDRESS = "127.0.0.1";
    public static final String LOCALHOST_HOSTNAME = "localhost";
    private final boolean appServerSslRequired = Boolean.parseBoolean(System.getProperty("app.server.ssl.required"));
    @Inject
    Instance<SuiteContext> suiteContext;
    @Inject
    Instance<TestContext> testContext;
    private static final Set<String> fixedUrls = new HashSet<String>();

    public Object doLookup(ArquillianResource resource, Annotation ... qualifiers) {
        URL url = (URL)super.doLookup(resource, qualifiers);
        if (url != null) {
            try {
                url = this.fixLocalhost(url);
                url = this.removeTrailingSlash(url);
                if (this.appServerSslRequired) {
                    url = this.fixSsl(url);
                }
            }
            catch (MalformedURLException ex) {
                this.log.log(Logger.Level.FATAL, null, (Throwable)ex);
            }
            if (!fixedUrls.contains(url.toString())) {
                fixedUrls.add(url.toString());
                this.log.debug((Object)("Fixed injected @ArquillianResource URL to: " + url));
            }
        }
        try {
            if ("eap6".equals(System.getProperty("app.server"))) {
                if (url == null) {
                    url = new URL("http://localhost:8080/");
                }
                URL fixedUrl = url;
                if (url.getPort() == 8080) {
                    Annotation[] annotationArray = qualifiers;
                    int n = annotationArray.length;
                    for (int i = 0; i < n; ++i) {
                        Annotation a = annotationArray[i];
                        if (!OperateOnDeployment.class.isAssignableFrom(a.annotationType())) continue;
                        String port = this.appServerSslRequired ? System.getProperty("app.server.https.port", "8643") : System.getProperty("app.server.http.port", "8280");
                        String protocol = this.appServerSslRequired ? "https" : "http";
                        url = new URL(fixedUrl.toExternalForm().replace("8080", port).replace("http", protocol) + ((OperateOnDeployment)a).value());
                    }
                }
                if (url.getPort() == 8080) {
                    url = null;
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        for (Annotation a : qualifiers) {
            if (AuthServerContext.class.isAssignableFrom(a.annotationType())) {
                return ((SuiteContext)this.suiteContext.get()).getAuthServerInfo().getContextRoot();
            }
            if (!AppServerContext.class.isAssignableFrom(a.annotationType())) continue;
            return ((TestContext)this.testContext.get()).getAppServerInfo().getContextRoot();
        }
        return url;
    }

    public URL fixLocalhost(URL url) throws MalformedURLException {
        URL fixedUrl = url;
        if (url.getHost().contains(LOCALHOST_ADDRESS)) {
            fixedUrl = new URL(fixedUrl.toExternalForm().replace(LOCALHOST_ADDRESS, LOCALHOST_HOSTNAME));
        }
        return fixedUrl;
    }

    public URL fixSsl(URL url) throws MalformedURLException {
        URL fixedUrl = url;
        String urlString = fixedUrl.toExternalForm().replace("http", "https").replace(System.getProperty("app.server.http.port", "8280"), System.getProperty("app.server.https.port", "8643"));
        return new URL(urlString);
    }

    public URL removeTrailingSlash(URL url) throws MalformedURLException {
        URL urlWithoutSlash = url;
        String urlS = url.toExternalForm();
        if (urlS.endsWith("/")) {
            urlWithoutSlash = new URL(urlS.substring(0, urlS.length() - 1));
        }
        return urlWithoutSlash;
    }
}

