/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.login;

import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.auth.page.account.AccountFields;
import org.keycloak.testsuite.auth.page.account.PasswordFields;
import org.keycloak.testsuite.page.Form;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginForm
extends Form {
    @Page
    private AccountFields accountFields;
    @Page
    private PasswordFields passwordFields;
    @Page
    private TotpSetupForm totpForm;
    @FindBy(name="login")
    private WebElement loginButton;
    @FindBy(xpath="//div[@id='kc-registration']/span/a")
    private WebElement registerLink;
    @FindBy(linkText="Forgot Password?")
    private WebElement forgottenPassword;
    @FindBy(id="rememberMe")
    private WebElement rememberMe;
    @FindBy(xpath=".//label[@for='password']")
    private WebElement labelPassword;

    public void setUsername(String username) {
        this.accountFields.setUsername(username);
    }

    public void setPassword(String password) {
        this.passwordFields.setPassword(password);
    }

    public void login(UserRepresentation user) {
        this.login(user.getUsername(), Users.getPasswordOf(user));
    }

    public void login(String username, String password) {
        this.setUsername(username);
        this.setPassword(password);
        this.login();
    }

    public void register() {
        this.registerLink.click();
        WaitUtils.waitForPageToLoad(this.driver);
    }

    public void login() {
        this.labelPassword.click();
        this.loginButton.click();
        WaitUtils.waitForPageToLoad(this.driver);
    }

    public void forgotPassword() {
        this.forgottenPassword.click();
        WaitUtils.waitForPageToLoad(this.driver);
    }

    public void rememberMe(boolean value) {
        boolean selected = this.rememberMe.isSelected();
        if (value && !selected || !value && selected) {
            this.rememberMe.click();
            WaitUtils.waitForPageToLoad(this.driver);
        }
    }

    public void waitForUsernameInputPresent() {
        this.accountFields.waitForUsernameInputPresent();
    }

    public void waitForRegisterLinkNotPresent() {
        WaitUtils.waitUntilElementIsNotPresent(this.driver, this.registerLink);
    }

    public void waitForResetPasswordLinkNotPresent() {
        ((IsElementBuilder)WaitUtils.waitUntilElement(this.forgottenPassword).is().not()).present();
    }

    public void waitForRememberMePresent() {
        WaitUtils.waitUntilElement(this.rememberMe).is().present();
    }

    public void waitForRememberMeNotPresent() {
        WaitUtils.waitUntilElementIsNotPresent(this.driver, this.rememberMe);
    }

    public void waitForLoginButtonPresent() {
        WaitUtils.waitUntilElement(this.loginButton).is().present();
    }

    public TotpSetupForm totpForm() {
        return this.totpForm;
    }

    public class TotpSetupForm
    extends Form {
        @FindBy(id="totp")
        private WebElement totpInputField;
        @FindBy(id="totpSecret")
        private WebElement totpSecret;
        @FindBy(xpath=".//input[@value='Submit']")
        private WebElement submit;

        public void waitForTotpInputFieldPresent() {
            WaitUtils.waitUntilElement(this.totpInputField).is().present();
        }

        public void setTotp(String value) {
            TotpSetupForm.setInputValue(this.totpInputField, value);
        }

        public String getTotpSecret() {
            return this.totpSecret.getAttribute("value");
        }

        public void submit() {
            this.submit.click();
            WaitUtils.waitForPageToLoad(this.driver);
        }
    }
}

