/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.login;

import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.auth.page.account.AccountFields;
import org.keycloak.testsuite.auth.page.account.ContactInfoFields;
import org.keycloak.testsuite.auth.page.account.PasswordFields;
import org.keycloak.testsuite.auth.page.login.LoginActions;

public class Registration
extends LoginActions {
    @Page
    private AccountFields accountFields;
    @Page
    private PasswordFields passwordFields;
    @Page
    private ContactInfoFields contactInfoFields;

    @Override
    public UriBuilder createUriBuilder() {
        return super.createUriBuilder().path("registration");
    }

    public void register(UserRepresentation user) {
        this.setValues(user);
        this.submit();
    }

    public void setValues(UserRepresentation user) {
        this.setValues(user, Users.getPasswordOf(user));
    }

    public void setValues(UserRepresentation user, String confirmPassword) {
        this.accountFields.setValues(user);
        this.passwordFields.setPassword(Users.getPasswordOf(user));
        this.passwordFields.setConfirmPassword(confirmPassword);
    }

    public void waitForUsernameInputPresent() {
        this.accountFields.waitForUsernameInputPresent();
    }

    public void waitForUsernameInputNotPresent() {
        this.accountFields.waitForUsernameInputNotPresent();
    }

    public void waitForConfirmPasswordInputPresent() {
        this.passwordFields.waitForConfirmPasswordInputPresent();
    }
}

